package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.vo.BidOpenResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 投标管理-开标结果
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("bidOpenResult")
public class BidOpenResultController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_OPEN_RESULT";

    @Autowired
    private IBidOpenResultService service;
    @Autowired
    private IBusOpportunityService busOpportunityService;
    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<BidOpenResultVO> dataList = new ArrayList<>();
        List<BidOpenResultEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, BidOpenResultVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<BidOpenResultVO> saveOrUpdate(@RequestBody BidOpenResultVO saveOrUpdateVO) {
    	BidOpenResultEntity entity = BeanMapper.map(saveOrUpdateVO, BidOpenResultEntity.class);
        LambdaQueryWrapper<BidOpenResultEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BidOpenResultEntity::getOpportunityId,saveOrUpdateVO.getOpportunityId())
                .ne(null!=saveOrUpdateVO.getId(),BidOpenResultEntity::getId,saveOrUpdateVO.getId())
                .eq(BidOpenResultEntity::getDr,0);
        int count = service.count(lambdaQueryWrapper);
        if (count>0){
            throw new BusinessException("该工程已存在开标结果！");
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }
    	service.saveOrUpdate(entity, false);
        if (entity.getIsBidWinning() == 1){
            BusOpportunityEntity opportunityEntity = busOpportunityService.selectById(entity.getOpportunityId());
            opportunityEntity.setIsBidWinningFlag(1);
            busOpportunityService.saveOrUpdate(opportunityEntity);
        }
    	BidOpenResultVO vo = BeanMapper.map(entity, BidOpenResultVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BidOpenResultVO> queryDetail(Long id) {
    	BidOpenResultEntity entity = service.selectById(id);
    	BidOpenResultVO vo = BeanMapper.map(entity, BidOpenResultVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<BidOpenResultVO> vos) {
        List<Long> ids = vos.stream().map(BidOpenResultVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)){
            for (Long id : ids) {
                BidOpenResultEntity bidOpenResultEntity = service.selectById(id);
                if (bidOpenResultEntity.getIsBidWinning() == 1){
                    BusOpportunityEntity opportunityEntity = busOpportunityService.selectById(bidOpenResultEntity.getOpportunityId());
                    opportunityEntity.setIsBidWinningFlag(0);
                    busOpportunityService.saveOrUpdate(opportunityEntity);
                }
            }
        }

        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BidOpenResultVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("techManagerName");
        fuzzyFields.add("otherPersonName");
        fuzzyFields.add("bidOpenType");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<BidOpenResultEntity> page = service.queryPage(param,false);
        IPage<BidOpenResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidOpenResultVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("techManagerName");
        fuzzyFields.add("otherPersonName");
        fuzzyFields.add("bidOpenType");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BidOpenResultEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidOpenResult-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBidOpenResultData", method = RequestMethod.GET)
    public CommonResponse<IPage<BidOpenResultVO>> refBidOepnResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("techManagerName");
        fuzzyFields.add("otherPersonName");
        fuzzyFields.add("bidOpenType");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BidOpenResultEntity> page = service.queryPage(param,false);
        IPage<BidOpenResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidOpenResultVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
