package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.CertSalaryDetailEntity;
/**
 * 人力行政-证书人员工资表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_salary")
public class CertSalaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="all_salary_mny")
    private BigDecimal allSalaryMny; // 应发工资总额
    @TableField(value="all_actual_salary_mny")
    private BigDecimal allActualSalaryMny; // 实发工资总额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="type")
    private String type; //1内部，2外部
    @TableField(exist=false)
    @SubEntity(serviceName="certSalaryDetailService", pidName = "certSalaryId")
    private List<CertSalaryDetailEntity> detailList = new ArrayList<>(); // 人力行政-证书人员工资表子表

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getAllSalaryMny() {
        return allSalaryMny;
    }

    public void setAllSalaryMny(BigDecimal allSalaryMny) {
        this.allSalaryMny = allSalaryMny;
    }
    public BigDecimal getAllActualSalaryMny() {
        return allActualSalaryMny;
    }

    public void setAllActualSalaryMny(BigDecimal allActualSalaryMny) {
        this.allActualSalaryMny = allActualSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }


    public List<CertSalaryDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CertSalaryDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
