package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.EmployeeFormalEntity;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.service.IEmployeeFormalService;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;

@Service("employeeFormal") 
public class EmployeeFormalBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IEmployeeIntoService employeeIntoService;
	@Autowired
	private IEmployeeFormalService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		EmployeeFormalEntity entity = service.selectById(billId);
		LambdaUpdateWrapper<EmployeeIntoEntity> uw = Wrappers.lambdaUpdate();
		uw.eq(EmployeeIntoEntity::getId,entity.getEmployeeId())
				.set(EmployeeIntoEntity::getFormalDate,entity.getFormalDate())
				.set(EmployeeIntoEntity::getContractTerm,entity.getContractTerm())
				.set(EmployeeIntoEntity::getContractDateBegin,entity.getContractDateBegin())
				.set(EmployeeIntoEntity::getContractDateEnd,entity.getContractDateEnd())
				.set(EmployeeIntoEntity::getEducatedSalary,entity.getEducatedSalary())
				.set(EmployeeIntoEntity::getSportSalary,entity.getSportSalary())
				.set(EmployeeIntoEntity::getYearSalaryId,entity.getYearSalaryId())
				.set(EmployeeIntoEntity::getYearSalary,entity.getYearSalary())
				.set(EmployeeIntoEntity::getYearChangeDate,entity.getYearChangeDate())
				.set(EmployeeIntoEntity::getYearSalaryInit,entity.getYearSalaryInit())
				.set(EmployeeIntoEntity::getOtherNeedPay,entity.getOtherNeedPay())
				.set(EmployeeIntoEntity::getCertSalary,entity.getCertSalary());
		employeeIntoService.update(uw);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		EmployeeFormalEntity entity = service.selectById(billId);
		LambdaUpdateWrapper<EmployeeIntoEntity> uw = Wrappers.lambdaUpdate();
		uw.eq(EmployeeIntoEntity::getId,entity.getEmployeeId())
				.set(EmployeeIntoEntity::getFormalDate,null)
				.set(EmployeeIntoEntity::getContractTerm,null)
				.set(EmployeeIntoEntity::getContractDateBegin,null)
				.set(EmployeeIntoEntity::getContractDateEnd,null)
				.set(EmployeeIntoEntity::getEducatedSalary,null)
				.set(EmployeeIntoEntity::getSportSalary,null)
				.set(EmployeeIntoEntity::getYearSalaryId,null)
				.set(EmployeeIntoEntity::getYearSalary,null)
				.set(EmployeeIntoEntity::getYearChangeDate,null)
				.set(EmployeeIntoEntity::getCertSalary,null);
		employeeIntoService.update(uw);
		return CommonResponse.success();
	}

}
