package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-证书人员退证申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_return")
public class CertReturnEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="human_pay_id")
    private Long humanPayId; // 姓名id
    @TableField(value="human_pay_name")
    private String humanPayName; // 姓名
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 岗位ID
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 证书结束时间
    @TableField(value="insured_begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredBeginDate; // 参保时间
    @TableField(value="insured_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredEndDate; // 停保时间
    @TableField(value="new_insured_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date newInsuredEndDate; // 本次停保时间
    @TableField(value="return_mny")
    private BigDecimal returnMny; // 退费金额
    @TableField(value="memo")
    private String memo; // 退证说明
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="un_pay_mny")
    private BigDecimal unPayMny; // 未支付金额
    @TableField(value="confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getHumanPayId() {
        return humanPayId;
    }

    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Date getInsuredBeginDate() {
        return insuredBeginDate;
    }

    public void setInsuredBeginDate(Date insuredBeginDate) {
        this.insuredBeginDate = insuredBeginDate;
    }
    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }
    public Date getNewInsuredEndDate() {
        return newInsuredEndDate;
    }

    public void setNewInsuredEndDate(Date newInsuredEndDate) {
        this.newInsuredEndDate = newInsuredEndDate;
    }
    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
