/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import com.ejianc.business.bid.mapper.ProjectPersonAffirmMapper;
import com.ejianc.business.bid.service.IProjectPersonAffirmService;
import com.ejianc.business.bid.vo.ProjectPersonAffirmVO;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectPersonAffirmService")
public class ProjectPersonAffirmServiceImpl
extends BaseServiceImpl<ProjectPersonAffirmMapper, ProjectPersonAffirmEntity>
implements IProjectPersonAffirmService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String BILL_CODE = "BID_PROJECT_PERSON_AFFIRM";

    @Override
    public List<ProjectPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"opportunity_id", (Object)id);
        query.orderByDesc((Object)"create_time");
        return super.list((Wrapper)query);
    }

    @Override
    public ProjectPersonAffirmVO saveOrUpdate(ProjectPersonAffirmVO saveOrUpdateVO) {
        ProjectPersonAffirmEntity entity = (ProjectPersonAffirmEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectPersonAffirmEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        }
        super.saveOrUpdate((Object)entity, false);
        ProjectPersonAffirmVO vo = (ProjectPersonAffirmVO)BeanMapper.map((Object)((Object)entity), ProjectPersonAffirmVO.class);
        if (null != vo.getProjectManagerId() && null != vo.getTechManagerId()) {
            Long documenterId = vo.getDocumenterId();
            ArrayList<String> pusherIds = new ArrayList<String>();
            pusherIds.add(documenterId.toString());
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            String formurl = this.baseHost + "ejc-bfyjerp-frontend/#/projectPersonAffirm";
            if (CollectionUtils.isNotEmpty(pusherIds)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(vo.getEngineeringName() + "\u7684\u9879\u76ee\u7ecf\u7406\u548c\u6280\u672f\u8d1f\u8d23\u4eba\u5df2\u7531" + this.sessionManager.getUserContext().getUserName() + "\u786e\u8ba4\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.feignUtil.sendMsg(messageType, pusherIds, "notice", subject, content, null);
            }
        } else {
            String pusherId = vo.getPusherId();
            ArrayList<String> pusherIds = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)pusherId)) {
                String[] split = pusherId.split(",");
                pusherIds.addAll(Arrays.asList(split));
            }
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            String formurl = this.baseHost + "ejc-bfyjerp-frontend/#/projectPersonAffirm";
            if (CollectionUtils.isNotEmpty(pusherIds)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(vo.getDocumenterName() + "\u586b\u5199\u7684" + vo.getEngineeringName() + "\u9879\u76ee\u7684\u4eba\u5458\u8981\u6c42\u5df2\u5b8c\u6210,\u8bf7\u53ca\u65f6\u786e\u8ba4\u9879\u76ee\u7ecf\u7406\u53ca\u6280\u672f\u8d1f\u8d23\u4eba");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.feignUtil.sendMsg(messageType, pusherIds, "notice", subject, content, null);
            }
        }
        return vo;
    }
}

