package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-退費申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_back_fee")
public class BackFeeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编号
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_id")
    private Long projectId; // 项目名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 区域ID
    @TableField(value="org_name")
    private String orgName; // 区域
    @TableField(value="registration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registrationDate; // 项目报名时间
    @TableField(value="open_tender_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date openTenderDate; // 项目开标时间
    @TableField(value="bidding_control_mmy")
    private BigDecimal biddingControlMmy; // 控制价(万元)
    @TableField(value="province_id")
    private Long provinceId; // 项目所属省份
    @TableField(value="province_name")
    private String provinceName; // 项目所属省份
    @TableField(value="follow_person_id")
    private Long followPersonId; // 业务经理
    @TableField(value="follow_person")
    private String followPerson; // 业务经理
    @TableField(value="registration_flag")
    private String registrationFlag; // 是否计入报名个数
    @TableField(value="follow_person_mmy")
    private BigDecimal followPersonMmy; // 业务经理提成
    @TableField(value="documenter_mmy")
    private BigDecimal documenterMmy; // 资料员提成
    @TableField(value="auth_mmy")
    private BigDecimal authMmy; // 授权人提成
    @TableField(value="qualification_mmy")
    private BigDecimal qualificationMmy; // 应收资质费
    @TableField(value="qualification_back_mmy")
    private BigDecimal qualificationBackMmy; // 资质退费金额
    @TableField(value="bid_doc_mny")
    private BigDecimal bidDocMny; // 标书费用
    @TableField(value="bid_doc_back_mny")
    private BigDecimal bidDocBackMny; // 标书退费金额
    @TableField(value="back_mny")
    private BigDecimal backMny; // 退费总金额
    @TableField(value="account_name")
    private String accountName; // 收款账户
    @TableField(value="account_num")
    private String accountNum; // 卡号
    @TableField(value="memo")
    private String memo; // 退费详细说明
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="un_pay_mny")
    private BigDecimal unPayMny; // 未支付金额
    @TableField(value="confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }
    public Date getOpenTenderDate() {
        return openTenderDate;
    }

    public void setOpenTenderDate(Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    public Long getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }
    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }
    public Long getFollowPersonId() {
        return followPersonId;
    }

    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    public String getRegistrationFlag() {
        return registrationFlag;
    }

    public void setRegistrationFlag(String registrationFlag) {
        this.registrationFlag = registrationFlag;
    }
    public BigDecimal getFollowPersonMmy() {
        return followPersonMmy;
    }

    public void setFollowPersonMmy(BigDecimal followPersonMmy) {
        this.followPersonMmy = followPersonMmy;
    }
    public BigDecimal getDocumenterMmy() {
        return documenterMmy;
    }

    public void setDocumenterMmy(BigDecimal documenterMmy) {
        this.documenterMmy = documenterMmy;
    }
    public BigDecimal getAuthMmy() {
        return authMmy;
    }

    public void setAuthMmy(BigDecimal authMmy) {
        this.authMmy = authMmy;
    }
    public BigDecimal getQualificationMmy() {
        return qualificationMmy;
    }

    public void setQualificationMmy(BigDecimal qualificationMmy) {
        this.qualificationMmy = qualificationMmy;
    }
    public BigDecimal getQualificationBackMmy() {
        return qualificationBackMmy;
    }

    public void setQualificationBackMmy(BigDecimal qualificationBackMmy) {
        this.qualificationBackMmy = qualificationBackMmy;
    }
    public BigDecimal getBidDocMny() {
        return bidDocMny;
    }

    public void setBidDocMny(BigDecimal bidDocMny) {
        this.bidDocMny = bidDocMny;
    }
    public BigDecimal getBidDocBackMny() {
        return bidDocBackMny;
    }

    public void setBidDocBackMny(BigDecimal bidDocBackMny) {
        this.bidDocBackMny = bidDocBackMny;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
