/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.TenderFileEntity;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.ITenderFileService;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.oa.bean.BackFeeEntity;
import com.ejianc.business.oa.mapper.BackFeeMapper;
import com.ejianc.business.oa.service.IBackFeeService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="backFeeService")
public class BackFeeServiceImpl
extends BaseServiceImpl<BackFeeMapper, BackFeeEntity>
implements IBackFeeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IBusOpportunityService busOpportunityService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBidOpenResultService bidOpenResultService;
    @Autowired
    private ITenderFileService tenderFileService;
    private final String northeastRegion = "\u4e1c\u5317\u5927\u533a";
    private final Integer ORG_TYPE_PROJECT_MANAGER_ORG = 3;

    @Override
    public JSONObject queryDetailByProjectId(Long projectId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("followPersonMmy", (Object)new BigDecimal(0));
        jsonObject.put("documenterMmy", (Object)new BigDecimal(0));
        jsonObject.put("authMmy", (Object)new BigDecimal(0));
        jsonObject.put("qualificationMmy", (Object)new BigDecimal(0));
        jsonObject.put("qualificationBackMmy", (Object)new BigDecimal(0));
        jsonObject.put("bidDocMny", (Object)new BigDecimal(0));
        jsonObject.put("bidDocBackMny", (Object)new BigDecimal(0));
        jsonObject.put("backMny", (Object)new BigDecimal(0));
        ProjectRegisterEntity projectRegisterEntity = (ProjectRegisterEntity)((Object)this.projectRegisterService.selectById(projectId));
        if (null != projectRegisterEntity.getOpportunityId()) {
            BusOpportunityEntity bp = (BusOpportunityEntity)((Object)this.busOpportunityService.selectById(projectRegisterEntity.getOpportunityId()));
            jsonObject = this.queryDetailByBusEntity(bp, jsonObject);
        }
        return jsonObject;
    }

    public JSONObject queryDetailByBusEntity(BusOpportunityEntity bp, JSONObject jsonObject) {
        List<BidOpenResultEntity> openResultList;
        if (null != bp.getRegistrationDate()) {
            jsonObject.put("registrationDate", (Object)DateUtil.format(bp.getRegistrationDate(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bp.getOpenTenderDate()) {
            jsonObject.put("openTenderDate", (Object)DateUtil.format(bp.getOpenTenderDate(), "yyyy-MM-dd HH:mm:ss"));
        }
        jsonObject.put("biddingControlMmy", (Object)bp.getBiddingControlMmy());
        jsonObject.put("provinceId", (Object)bp.getProvinceId());
        jsonObject.put("provinceName", (Object)bp.getProvinceName());
        jsonObject.put("followPersonId", (Object)bp.getFollowPersonId());
        jsonObject.put("followPerson", (Object)bp.getFollowPerson());
        HashSet<Long> emplyeeIds = new HashSet<Long>();
        HashMap<Long, EmployeeVO> empIdMap = new HashMap<Long, EmployeeVO>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashMap<Long, OrgVO> orgIdMap = new HashMap<Long, OrgVO>();
        if (null != bp.getFollowPersonId()) {
            emplyeeIds.add(bp.getFollowPersonId());
        }
        if (null != bp.getDocumenterId()) {
            emplyeeIds.add(bp.getDocumenterId());
        }
        if (null != bp.getNetAuthPersonId()) {
            emplyeeIds.add(bp.getNetAuthPersonId());
        }
        if (null != bp.getSiteAuthPersonId()) {
            emplyeeIds.add(bp.getSiteAuthPersonId());
        }
        orgIds.add(bp.getOrgId());
        if (CollectionUtils.isNotEmpty(emplyeeIds)) {
            CommonResponse empList = this.employeeApi.getJustByIds(new ArrayList(emplyeeIds));
            if (!empList.isSuccess()) {
                this.logger.error("\u6839\u636e\u4eba\u5458id\u5217\u8868{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(emplyeeIds), (Object)JSONObject.toJSONString((Object)empList));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)empList.getData()))) {
                for (EmployeeVO employee : (List)empList.getData()) {
                    if (1 != employee.getJobType()) continue;
                    empIdMap.put(employee.getId(), employee);
                    orgIds.add(employee.getOrgId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            CommonResponse orgResp = this.orgApi.findAllByIds(new ArrayList(orgIds));
            if (!orgResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7id\u5217\u8868{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(orgIds), (Object)JSONObject.toJSONString((Object)orgResp));
            }
            orgIdMap.putAll(((List)orgResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(openResultList = this.bidOpenResultService.getByBusOpportunityId(bp.getId()))) {
            BidOpenResultEntity result = openResultList.get(0);
            EmployeeVO tmpEmp = null;
            if ("\u7f51\u5f00".equals(result.getBidOpenType())) {
                if (null != bp.getNetAuthPersonId()) {
                    tmpEmp = (EmployeeVO)empIdMap.get(bp.getNetAuthPersonId());
                }
            } else if (null != bp.getSiteAuthPersonId()) {
                tmpEmp = (EmployeeVO)empIdMap.get(bp.getNetAuthPersonId());
            }
            if (null == tmpEmp) {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6388\u6743\u4ebaid-{}\uff0c\u6388\u6743\u4eba\u7c7b\u578b\uff1a{}, \u67e5\u8be2\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406~", new Object[]{bp.getId(), bp.getDocumenterId(), result.getBidOpenType()});
            } else if ("\u7f51\u5f00".equals(result.getBidOpenType()) && "\u4e1c\u5317\u5927\u533a".equals(bp.getNetAuthPersonOrgName())) {
                jsonObject.put("authMmy", (Object)new BigDecimal("40"));
            } else if ("\u73b0\u573a".equals(result.getBidOpenType()) && "\u4e1c\u5317\u5927\u533a".equals(bp.getSiteAuthPersonOrgName())) {
                jsonObject.put("authMmy", (Object)new BigDecimal("100"));
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6388\u6743\u4ebaid-{}\uff0c\u6388\u6743\u4eba\u7c7b\u578b\uff1a{}, \u76f4\u5c5e\u7ec4\u7ec7\u975e\u4e1c\u5317\u5927\u533a\uff0c\u8df3\u8fc7\u5904\u7406~", new Object[]{bp.getId(), bp.getDocumenterId(), result.getBidOpenType()});
            }
        } else {
            this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u4e0d\u5b58\u5728\u751f\u6548\u7684\u5f00\u5305\u8bb0\u5f55\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
        }
        if (null != bp.getDocumenterId() && empIdMap.containsKey(bp.getDocumenterId())) {
            EmployeeVO tmpEmp = (EmployeeVO)empIdMap.get(bp.getDocumenterId());
            if ("\u4e1c\u5317\u5927\u533a".equals(bp.getDocumenterOrgName())) {
                if (orgIdMap.containsKey(bp.getOrgId()) && !this.ORG_TYPE_PROJECT_MANAGER_ORG.equals(((OrgVO)orgIdMap.get(bp.getOrgId())).getOrgType())) {
                    List<TenderFileEntity> fileList = this.tenderFileService.getByBusOpportunityId(bp.getId());
                    if (CollectionUtils.isNotEmpty(fileList)) {
                        jsonObject.put("documenterMmy", (Object)new BigDecimal("40"));
                    } else {
                        this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6ca1\u6709\u751f\u6548\u7684\u8d44\u6599\u4e0a\u4f20\u5355\u636e\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getOrgId());
                    }
                } else {
                    this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u6240\u5c5e\u7ec4\u7ec7id-{}\u7c7b\u578b\u4e3a\u529e\u4e8b\u5904\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getOrgId());
                }
            } else {
                this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8d44\u6599\u5458id-{}\u76f4\u5c5e\u7ec4\u7ec7\u4e0d\u662f\u4e1c\u5317\u5927\u533a\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
            }
        } else {
            this.logger.error("\u5546\u673a\u767b\u8bb0\u5355id-{} \u8d44\u6599\u5458id-{}\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406~", (Object)bp.getId(), (Object)bp.getDocumenterId());
        }
        jsonObject.put("followPersonMmy", (Object)ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)bp.getQualificationFee(), (BigDecimal)new BigDecimal("0.25")), (BigDecimal)((BigDecimal)jsonObject.get((Object)"authMmy"))));
        jsonObject.put("qualificationMmy", (Object)ComputeUtil.nullToZero((BigDecimal)bp.getQualificationFee()));
        jsonObject.put("bidDocMny", (Object)ComputeUtil.nullToZero((BigDecimal)bp.getBiddingFee()));
        jsonObject.put("bidDocBackMny", (Object)new BigDecimal(0));
        jsonObject.put("qualificationBackMmy", (Object)ComputeUtil.safeSub((BigDecimal)jsonObject.getBigDecimal("qualificationMmy"), (BigDecimal[])new BigDecimal[]{jsonObject.getBigDecimal("followPersonMmy"), jsonObject.getBigDecimal("documenterMmy"), jsonObject.getBigDecimal("authMmy")}));
        jsonObject.put("backMny", (Object)ComputeUtil.safeAdd((BigDecimal)jsonObject.getBigDecimal("qualificationBackMmy"), (BigDecimal)jsonObject.getBigDecimal("bidDocBackMny")));
        return jsonObject;
    }
}

