/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.enums.ChangeStateEnum;
import com.ejianc.business.oa.mapper.CertRecordMapper;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.service.ICertTypeService;
import com.ejianc.business.oa.vo.CertRecordDetailImportVO;
import com.ejianc.business.oa.vo.CertRecordRecordVO;
import com.ejianc.business.oa.vo.CertRecordVO;
import com.ejianc.business.oa.vo.CertTypeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="certRecordService")
public class CertRecordServiceImpl
extends BaseServiceImpl<CertRecordMapper, CertRecordEntity>
implements ICertRecordService {
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICertTypeService certTypeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "BFYJ_OA_ZSDA";

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CertRecordDetailImportVO> successList = new ArrayList<CertRecordDetailImportVO>();
        ArrayList<CertRecordDetailImportVO> errorList = new ArrayList<CertRecordDetailImportVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 14) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            List<CertTypeVO> certTypeList = this.certTypeService.queryListEntityTree(new HashMap<String, Object>());
            Map<String, CertTypeVO> defDocMap = certTypeList.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));
            HashMap<String, OrgVO> orgMap = new HashMap<String, OrgVO>();
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                CertRecordDetailImportVO importVO = new CertRecordDetailImportVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errorMessage.append("[\u8bc1\u7167\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(0)).length() > 200) {
                        errorMessage.append("[\u586b\u5199\u8bc1\u7167\u7c7b\u522b\u957f\u5ea6\u4e3a1~200\u5b57]");
                    }
                    if (defDocMap.containsKey(((String)datas.get(0)).trim())) {
                        importVO.setCertTypeName(((String)datas.get(0)).trim());
                        importVO.setCertType(defDocMap.get(((String)datas.get(0)).trim()).getId());
                    } else {
                        errorMessage.append("[\u8bf7\u5728\u8bc1\u7167\u5206\u7c7b\u6863\u6848\u6dfb\u52a0\u8be5\u8bc1\u7167\u7c7b\u522b\u9879\uff01]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    if (((String)datas.get(1)).length() > 200) {
                        errorMessage.append("[\u586b\u5199\u8bc1\u7167\u540d\u79f0\u957f\u5ea6\u4e3a1~200\u5b57]");
                    }
                    if (defDocMap.containsKey(((String)datas.get(1)).trim())) {
                        if (importVO.getCertType().longValue() != defDocMap.get(((String)datas.get(1)).trim()).getParentId().longValue()) {
                            errorMessage.append("[\u8be5\u8bc1\u7167\u540d\u79f0\u9879\u4e0d\u662f\u8bc1\u7167\u5206\u7c7b\u7684\u4e0b\u7ea7\uff01]");
                        } else {
                            importVO.setCertName(((String)datas.get(1)).trim());
                            importVO.setCertNameId(defDocMap.get(((String)datas.get(1)).trim()).getId());
                        }
                    } else {
                        errorMessage.append("[\u8bf7\u5728\u8bc1\u7167\u5206\u7c7b\u6863\u6848\u6dfb\u52a0\u8be5\u8bc1\u7167\u540d\u79f0\u9879\uff01]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    errorMessage.append("[\u8bc1\u7167\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(2)).length() > 50) {
                        errorMessage.append("[\u586b\u5199\u8bc1\u7167\u7f16\u53f7\u957f\u5ea6\u4e3a1~50\u5b57]");
                    }
                    importVO.setCertCode(((String)datas.get(2)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    if (((String)datas.get(3)).length() > 200) {
                        errorMessage.append("[\u586b\u5199\u8bc1\u4e66\u4e13\u4e1a\u957f\u5ea6\u4e3a1~200\u5b57]");
                    }
                    if (defDocMap.containsKey(((String)datas.get(3)).trim())) {
                        if (importVO.getCertNameId().longValue() != defDocMap.get(((String)datas.get(3)).trim()).getParentId().longValue()) {
                            errorMessage.append("[\u8be5\u8bc1\u4e66\u4e13\u4e1a\u4e0d\u662f\u8bc1\u7167\u540d\u79f0\u7684\u4e0b\u7ea7\uff01]");
                        } else {
                            importVO.setCertMajor(((String)datas.get(3)).trim());
                            importVO.setCertMajorId(defDocMap.get(((String)datas.get(3)).trim()).getId());
                        }
                    } else {
                        errorMessage.append("[\u8bf7\u5728\u8bc1\u7167\u5206\u7c7b\u6863\u6848\u6dfb\u52a0\u8be5\u8bc1\u4e66\u4e13\u4e1a\u9879\uff01]");
                    }
                }
                importVO.setAuthorities((String)datas.get(4));
                importVO.setApproveNum((String)datas.get(5));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importVO.setBeginTime(DateUtils.parseDate((String)((String)datas.get(6)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e2) {
                        errorMessage.append("[\u751f\u6548\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e2.printStackTrace();
                    }
                } else {
                    errorMessage.append("[\u751f\u6548\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    errorMessage.append("[\u6709\u65e0\u671f\u9650\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setTermName(((String)datas.get(7)).trim());
                    importVO.setTerm(Integer.valueOf("\u6709".equals(((String)datas.get(7)).trim()) ? 1 : 2));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        importVO.setEndTime(DateUtils.parseDate((String)((String)datas.get(8)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e3) {
                        errorMessage.append("[\u5931\u6548\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e3.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        importVO.setElectronCertDate(DateUtils.parseDate((String)((String)datas.get(9)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e4) {
                        errorMessage.append("[\u7535\u5b50\u8bc1\u7167\u6709\u6548\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e4.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        importVO.setSendCertDate(DateUtils.parseDate((String)((String)datas.get(10)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e5) {
                        errorMessage.append("[\u53d1\u8bc1\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e5.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    importVO.setCertStateName(((String)datas.get(11)).trim());
                    importVO.setCertState(Integer.valueOf("\u662f".equals(((String)datas.get(11)).trim()) ? 1 : 2));
                }
                importVO.setPlace((String)datas.get(12));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    if (orgMap.containsKey(datas.get(13))) {
                        importVO.setOrgDetailId(((OrgVO)orgMap.get(datas.get(13))).getId());
                        importVO.setOrgDetailName(((OrgVO)orgMap.get(datas.get(13))).getName());
                    } else {
                        CommonResponse orgResp = this.orgApi.findByNameAndTenantId((String)datas.get(13), InvocationInfoProxy.getTenantid());
                        if (!orgResp.isSuccess()) {
                            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        }
                        if (null != orgResp.getData()) {
                            OrgVO orgVO = (OrgVO)orgResp.getData();
                            orgMap.put(orgVO.getName(), orgVO);
                            importVO.setOrgDetailId(orgVO.getId());
                            importVO.setOrgDetailName(orgVO.getName());
                        }
                    }
                }
                importVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<CertRecordVO> insertOrUpdate(CertRecordVO saveOrUpdateVO) {
        CertRecordEntity revise;
        CertRecordEntity entity = (CertRecordEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CertRecordEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getLastTaskId()) {
                entity.setTaskVersion(1);
                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            }
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        }
        this.saveOrUpdate((Object)entity, false);
        if (entity.getLastTaskId() != null && (revise = (CertRecordEntity)((Object)super.getById((Serializable)entity.getLastTaskId()))).getLatestFlag().booleanValue()) {
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setLatestFlag(false);
            revise.setBaseTaskId(null != revise.getBaseTaskId() ? revise.getBaseTaskId() : revise.getId());
            super.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public CertRecordVO queryDetail(Long id) {
        CertRecordEntity entity = (CertRecordEntity)((Object)super.selectById((Serializable)id));
        CertRecordVO vo = (CertRecordVO)BeanMapper.map((Object)((Object)entity), CertRecordVO.class);
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CertRecordEntity::getBaseTaskId, (Object)entity.getBaseTaskId());
        queryWrapper.in(CertRecordEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List taskEntityList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)taskEntityList)) {
            list = BeanMapper.mapList((Iterable)taskEntityList, CertRecordRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public CertRecordVO queryChangeDetail(Long id) {
        CertRecordEntity entity = (CertRecordEntity)((Object)super.selectById((Serializable)id));
        CertRecordVO vo = (CertRecordVO)BeanMapper.map((Object)((Object)entity), CertRecordVO.class);
        vo.setId(Long.valueOf(IdWorker.getId()));
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBeforeTaskVersion(vo.getTaskVersion());
        vo.setTaskVersion(Integer.valueOf(vo.getTaskVersion() + 1));
        vo.setLastTaskId(id);
        vo.setBaseTaskId(null != entity.getBaseTaskId() ? entity.getBaseTaskId() : id);
        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);
        List detailList = vo.getCertRecordDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("add");
            });
            vo.setCertRecordDetailList(detailList);
        }
        this.attachmentApi.copyFiles(String.valueOf(id), "BT202411000036", "marketBill001", String.valueOf(vo.getId()), "BT202411000036", "marketBill001", true);
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<CertRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CertRecordVO taskVO : vos) {
                CertRecordEntity taskEntity = (CertRecordEntity)((Object)super.selectById((Serializable)taskVO.getId()));
                if (taskEntity.getLastTaskId() == null) continue;
                CertRecordEntity revise = (CertRecordEntity)((Object)super.getById((Serializable)taskEntity.getLastTaskId()));
                revise.setChangeId(null);
                revise.setLatestFlag(true);
                revise.setChangeState(1 == taskEntity.getTaskVersion() ? ChangeStateEnum.\u672a\u53d8\u66f4.getCode() : ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
                super.saveOrUpdate((Object)revise);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

