package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.ejianc.business.bid.bean.BidServiceFeeEntity;
import com.ejianc.business.bid.bean.MonthFeeApplyEntity;
import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.service.IBidServiceFeeService;
import com.ejianc.business.bid.service.IMonthFeeApplyService;
import com.ejianc.business.bid.service.ITenderFundsBackService;
import com.ejianc.business.bid.service.ITenderFundsService;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayMigrantEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayMigrantService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.invest.bean.PersonDebtEntity;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.service.IPersonDebtService;
import com.ejianc.business.invest.service.IProjectDebtService;
import com.ejianc.business.oa.bean.*;
import com.ejianc.business.oa.service.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordVO;

/**
 * 出纳资金-支付记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payRecord")
public class PayRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPayRecordService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private ITenderFundsService tenderFundsService;
    @Autowired
    private ITenderFundsBackService tenderFundsBackService;
    @Autowired
    private IBidServiceFeeService bidServiceFeeService;
    @Autowired
    private IBackFeeService backFeeService;
    @Autowired
    private ICertPayService certPayService;
    @Autowired
    private ICertKeepService certKeepService;
    @Autowired
    private ICertReturnService certReturnService;
    @Autowired
    private ICertSalaryService  certSalaryService;
    @Autowired
    private IPayrollService  payrollService;
    @Autowired
    private IProjectDebtService projectDebtService;
    @Autowired
    private IPersonDebtService personDebtService;
    @Autowired
    private IMonthFeeApplyService monthFeeApplyService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayMigrantService payMigrantService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordVO> saveOrUpdate(@RequestBody PayRecordVO vo) {
    	PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
    	if("1".equals(vo.getApplyType())){
    	    //合同付款申请
            PayContractEntity applyEntity = payContractService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType(applyEntity.getProjectType());
            entity.setContractId(applyEntity.getContractId());
            entity.setContractName(applyEntity.getContractName());
            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
            entity.setParentOrgId(applyEntity.getParentOrgId());
            entity.setParentOrgCode(applyEntity.getParentOrgCode());
            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(applyEntity.getPayType());
            entity.setApplyDate(applyEntity.getApplyDate());
            entity.setApplyMny(applyEntity.getApplyMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getApplyMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            payContractService.updateById(applyEntity);
            
        }else if("2".equals(vo.getApplyType())){
            //零星付款申请
            PaySporadicEntity applyEntity = paySporadicService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType(applyEntity.getProjectType());
            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
            entity.setParentOrgId(applyEntity.getParentOrgId());
            entity.setParentOrgCode(applyEntity.getParentOrgCode());
            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(applyEntity.getPayType());
            entity.setApplyDate(applyEntity.getApplyDate());
            entity.setApplyMny(applyEntity.getApplyMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getApplyMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            paySporadicService.updateById(applyEntity);

        }else if("3".equals(vo.getApplyType()) || "4".equals(vo.getApplyType())){
            //工人工资、证书费用申请
            PayMigrantEntity applyEntity = payMigrantService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType(applyEntity.getProjectType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
            entity.setParentOrgId(applyEntity.getParentOrgId());
            entity.setParentOrgCode(applyEntity.getParentOrgCode());
            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(applyEntity.getPayType());
            entity.setApplyDate(applyEntity.getApplyDate());
            entity.setApplyMny(applyEntity.getApplyMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getApplyMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            payMigrantService.updateById(applyEntity);
        }else if("5".equals(vo.getApplyType())){
            //保证金申请
            TenderFundsEntity applyEntity = tenderFundsService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getOpportunityId());
            entity.setProjectName(applyEntity.getEngineeringName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getPaymentEndDate());
            entity.setApplyMny(applyEntity.getMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            tenderFundsService.updateById(applyEntity);
        }else if("6".equals(vo.getApplyType())){
            //保证金退还
            TenderFundsBackEntity applyEntity = tenderFundsBackService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getOpportunityId());
            entity.setProjectName(applyEntity.getEngineeringName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            tenderFundsBackService.updateById(applyEntity);
        }else if("7".equals(vo.getApplyType())){
            //服务费、报名费
            BidServiceFeeEntity applyEntity = bidServiceFeeService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getOpportunityId());
            entity.setProjectName(applyEntity.getEngineeringName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getPayMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMnyRecord(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getPayMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            bidServiceFeeService.updateById(applyEntity);
        }else if("8".equals(vo.getApplyType())){
            //退费申请单
            BackFeeEntity applyEntity = backFeeService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
//            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getBackMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getBackMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            backFeeService.updateById(applyEntity);
        }else if("9".equals(vo.getApplyType())){
            //证书人员付款申请（年）
            CertPayEntity applyEntity = certPayService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
//            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getInDate());
            entity.setApplyMny(applyEntity.getCertMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getCertMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            certPayService.updateById(applyEntity);
        }else if("10".equals(vo.getApplyType())){
            //证书人员延续申请
            CertKeepEntity applyEntity = certKeepService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
//            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getEndDate());
            entity.setApplyMny(applyEntity.getNewCertMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getNewCertMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            certKeepService.updateById(applyEntity);
        }else if("11".equals(vo.getApplyType())){
            //证书人员退证申请
            CertReturnEntity applyEntity = certReturnService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
//            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getNewInsuredEndDate());
            entity.setApplyMny(applyEntity.getReturnMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getReturnMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            certReturnService.updateById(applyEntity);
        }else if("12".equals(vo.getApplyType())){
            //证书人员工资表
            CertSalaryEntity applyEntity = certSalaryService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getAllActualSalaryMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getAllActualSalaryMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTimeRecord(entity.getConfirmTime());
            certSalaryService.updateById(applyEntity);
        }else if("13".equals(vo.getApplyType())){
            //工资单
            PayrollEntity applyEntity = payrollService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getTotalActualSalaryMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getTotalActualSalaryMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTimeRecord(entity.getConfirmTime());
            payrollService.updateById(applyEntity);
        }else if("14".equals(vo.getApplyType())){
            //项目借款
            ProjectDebtEntity applyEntity = projectDebtService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getDebtMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getDebtMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTimeRecord(entity.getConfirmTime());
            projectDebtService.updateById(applyEntity);
        }else if("15".equals(vo.getApplyType())){
            //个人借款
            PersonDebtEntity applyEntity = personDebtService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
            entity.setProjectId(applyEntity.getProjectId());
            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getDebtMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getDebtMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTimeRecord(entity.getConfirmTime());
            personDebtService.updateById(applyEntity);
        }else if("16".equals(vo.getApplyType())){
            //月度费用提成申请
            MonthFeeApplyEntity applyEntity = monthFeeApplyService.selectById(entity.getPayapplyId());
            entity.setApplyBillCode(applyEntity.getBillCode());
            entity.setProjectType("2");
//            entity.setContractId(applyEntity.getContractId());
//            entity.setContractName(applyEntity.getContractName());
//            entity.setContractType(applyEntity.getContractType());
//            entity.setProjectId(applyEntity.getProjectId());
//            entity.setProjectName(applyEntity.getProjectName());
            entity.setOrgId(applyEntity.getOrgId());
//            entity.setOrgCode(applyEntity.getOrgCode());
            entity.setOrgName(applyEntity.getOrgName());
//            entity.setParentOrgId(applyEntity.getParentOrgId());
//            entity.setParentOrgCode(applyEntity.getParentOrgCode());
//            entity.setParentOrgName(applyEntity.getParentOrgName());
            entity.setPayType(1);
            entity.setApplyDate(applyEntity.getCreateTime());
            entity.setApplyMny(applyEntity.getMny());
            service.saveOrUpdate(entity, false);

            //回写申请单
            applyEntity.setPayMny(ComputeUtil.safeAdd(entity.getThisPayMny(),applyEntity.getPayMny()));//支付金额
            applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getMny(),applyEntity.getPayMny()));//未支付金额
            applyEntity.setConfirmTime(entity.getConfirmTime());
            monthFeeApplyService.updateById(applyEntity);
        }

    	PayRecordVO saveOrUpdateVO = BeanMapper.map(entity, PayRecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayRecordVO> queryDetail(Long id) {
    	PayRecordEntity entity = service.selectById(id);
    	PayRecordVO vo = BeanMapper.map(entity, PayRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PayRecordEntity> page = service.queryPage(param,false);
        IPage<PayRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PayRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPayRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayRecordVO>> refPayRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayRecordEntity> page = service.queryPage(param,false);
        IPage<PayRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
