package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.utils.ReformState;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("checkResult")
public class CheckResultController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckBfyjService service;
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;

    @Autowired
    private IOrgApi iOrgApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> queryDetail(@RequestParam Long id) {
        CheckBfyjEntity entity = service.selectById(id);
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<CheckDetailBfyjVO> CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails, CheckDetailBfyjVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            CheckDetailBfyjVOList.forEach(item -> {
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        CheckBfyjVO vo = BeanMapper.map(entity, CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //移动端和pc端权限处理
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("overdueNum")) {
            String overdueNum = (String) params.get("overdueNum").getValue();
            params.remove("overdueNum");
            if (overdueNum.equals("1")) {
                param.getParams().put("overdueNum", new Parameter(QueryParam.GT, 0));
            }
            if (overdueNum.equals("0")) {
                param.getParams().put("overdueNum", new Parameter(QueryParam.EQ, 0));
            }
        }
        IPage<CheckBfyjEntity> page = service.queryPage(param, false);
        IPage<CheckBfyjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckBfyjVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<CheckBfyjEntity> list = service.queryList(param);
        List<CheckBfyjVO> sceneCheckVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            sceneCheckVOS = BeanMapper.mapList(list, CheckBfyjVO.class);
            sceneCheckVOS.forEach(vo -> {
                vo.setReformName(ReformState.getEnumByStateCode(vo.getReformStatus()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("SceneCheckResult-export.xlsx", beans, response);
    }


}
