/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.EmployeeFormalEntity;
import com.ejianc.business.oa.service.IEmployeeFormalService;
import com.ejianc.business.oa.vo.EmployeeFormalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"employeeFormal"})
public class EmployeeFormalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_OA_YGZZ";
    @Autowired
    private IEmployeeFormalService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EmployeeFormalVO> saveOrUpdate(@RequestBody EmployeeFormalVO saveOrUpdateVO) throws ParseException {
        String createTime;
        EmployeeFormalEntity entity = (EmployeeFormalEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, EmployeeFormalEntity.class));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String yearChangeDate = simpleDateFormat.format(saveOrUpdateVO.getYearChangeDate());
        String string = createTime = null != saveOrUpdateVO.getCreateTime() ? simpleDateFormat.format(saveOrUpdateVO.getCreateTime()) : simpleDateFormat.format(new Date());
        if (createTime.compareTo(yearChangeDate) > 0) {
            throw new BusinessException("\u53f8\u9f84\u521d\u59cb\u8c03\u6574\u6708\u4efd\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5236\u5355\u6708");
        }
        SimpleDateFormat monFormat = new SimpleDateFormat("MM");
        String yearMonDate = monFormat.format(saveOrUpdateVO.getYearChangeDate());
        String format = monFormat.format(saveOrUpdateVO.getFormalDate());
        int formalMno = Integer.valueOf(format) + 1;
        if (formalMno == 13) {
            formalMno = 1;
        }
        if (!Integer.valueOf(yearMonDate).equals(formalMno)) {
            throw new BusinessException("\u53f8\u9f84\u521d\u59cb\u8c03\u6574\u6708\u4efd/\uff08\u8f6c\u6b63\u6708\u4efd+1\uff09\uff0c\u5fc5\u987b\u662f\u6574\u6570");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            List entityList = this.service.list((Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)saveOrUpdateVO.getEmployeeId()));
            if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u4eba\u5458\u5df2\u505a\u8f6c\u6b63\u7533\u8bf7\uff0c\u8bf7\u5207\u6362\u4eba\u5458\uff01");
            }
        } else {
            List entityList = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"employee_id", (Object)saveOrUpdateVO.getEmployeeId())).ne((Object)"id", (Object)saveOrUpdateVO.getId()));
            if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u4eba\u5458\u5df2\u505a\u8f6c\u6b63\u7533\u8bf7\uff0c\u8bf7\u5207\u6362\u4eba\u5458\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EmployeeFormalVO vo = (EmployeeFormalVO)BeanMapper.map((Object)((Object)entity), EmployeeFormalVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EmployeeFormalVO> queryDetail(Long id) {
        EmployeeFormalEntity entity = (EmployeeFormalEntity)((Object)this.service.selectById(id));
        EmployeeFormalVO vo = (EmployeeFormalVO)BeanMapper.map((Object)((Object)entity), EmployeeFormalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EmployeeFormalVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EmployeeFormalVO employeeFormalVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EmployeeFormalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EmployeeFormalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("EmployeeFormal-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEmployeeFormalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EmployeeFormalVO>> refEmployeeFormalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EmployeeFormalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

