/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.InstoreDetailEntity;
import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.service.IInstoreDetailService;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.service.IMoutaiOutService;
import com.ejianc.business.oa.utlis.ArchivesUtil;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import com.ejianc.business.oa.vo.InstoreVO;
import com.ejianc.business.oa.vo.MoutaiOutVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"instore"})
public class InstoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ArchivesUtil archivesUtil;
    private static final String BILL_CODE = "OA_INSTORE";
    @Autowired
    private IInstoreService service;
    @Autowired
    private IInstoreDetailService instoreDetailService;
    @Autowired
    private IMoutaiOutService moutaiOutService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreVO> saveOrUpdate(@RequestBody InstoreVO saveOrUpdateVO) {
        List<InstoreDetailEntity> detailList;
        List newMaterialList;
        InstoreEntity entity = (InstoreEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InstoreEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(newMaterialList = (detailList = entity.getDetailList()).stream().filter(e -> null != e.getSourceType() && "0".equals(e.getSourceType())).collect(Collectors.toList()))) {
            for (InstoreDetailEntity instoreMaterialEntity : newMaterialList) {
                String onlykey = instoreMaterialEntity.getMaterialCategoryName() + instoreMaterialEntity.getMaterialName() + instoreMaterialEntity.getMaterialUnit() + instoreMaterialEntity.getMaterialSpec() + instoreMaterialEntity.getMaterialCode();
                instoreMaterialEntity.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(newMaterialList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "materialUnit", "materialSpec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, InstoreDetailEntity.class);
            entity.setDetailList(list);
            entity.getDetailList().addAll(detailList.stream().filter(e -> null != e.getSourceType() && "1".equals(e.getSourceType())).collect(Collectors.toList()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        InstoreVO vo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InstoreVO> queryDetail(Long id) {
        InstoreEntity entity = (InstoreEntity)((Object)this.service.selectById(id));
        InstoreVO vo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstoreVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InstoreVO instoreVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "storeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InstoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "storeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, InstoreVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("Instore-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInstoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> refInstoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InstoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"calculateCanUseNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success((String)"\u8ba1\u7b97\u53ef\u7528\u5e93\u5b58\u6210\u529f\uff01", (Object)this.service.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }

    @RequestMapping(value={"calNowNumber"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> calNowNumber(@RequestParam Long storeId, @RequestParam(value="materialIds") List<Long> materialIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u4ed3\u5e93\u73b0\u5b58\u5e93\u5b58\u6570\u91cf\uff01", this.service.calNowNumber(storeId, materialIds));
    }

    @RequestMapping(value={"refCanUseNumData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreDetailVO>> refCanUseNumData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText, String searchObject) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        if (StringUtils.isBlank((CharSequence)con.getString("storeId"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u4ed3\u5e93\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter("eq", (Object)con.getString("storeId")));
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        Page pageVo = new Page();
        IPage<InstoreDetailVO> entityPage = this.instoreDetailService.queryStoreCanUseNumPageData(searchText, searchObject, null, con.getLong("storeId"), pageNumber, pageSize);
        if (entityPage != null) {
            ArrayList voList = new ArrayList();
            entityPage.getRecords().forEach(e -> {
                InstoreDetailVO vo = (InstoreDetailVO)BeanMapper.map((Object)e, InstoreDetailVO.class);
                vo.setCanUseNumber(this.service.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize((long)queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u51fa\u5e93\u53ef\u7528\u7269\u8d44\u53c2\u7167\u6210\u529f\uff01", entityPage);
    }

    @RequestMapping(value={"refCanUseNumDataAllDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreDetailVO>> refCanUseNumDataAllDate(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText, String searchObject) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        if (StringUtils.isBlank((CharSequence)con.getString("storeId"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u4ed3\u5e93\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter("eq", (Object)con.getString("storeId")));
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        Page pageVo = new Page();
        IPage<InstoreDetailVO> entityPage = this.instoreDetailService.queryStoreCanUseNumPageDataAll(searchText, searchObject, null, con.getLong("storeId"), pageNumber, pageSize, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u51fa\u5e93\u53ef\u7528\u7269\u8d44\u53c2\u7167\u6210\u529f\uff01", entityPage);
    }

    @RequestMapping(value={"/queryStoreData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryStoreData(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InstoreDetailVO> pageData = this.instoreDetailService.queryStoreData((Page<InstoreDetailEntity>)page, (QueryWrapper<InstoreDetailVO>)queryWrapper);
        JSONObject res = new JSONObject();
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelStoreDataExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelStoreDataExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<InstoreDetailVO> voList = this.instoreDetailService.queryStoreData((Page<InstoreDetailEntity>)page, (QueryWrapper<InstoreDetailVO>)queryWrapper);
        HashMap<String, List<InstoreDetailVO>> beans = new HashMap<String, List<InstoreDetailVO>>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("StoreData-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryMoutaiNumByMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MoutaiOutVO> queryMoutaiNumByMonth(String month) {
        MoutaiOutVO moutaiOutVO = new MoutaiOutVO();
        List moutaiOutEntityList = this.moutaiOutService.list((Wrapper)new QueryWrapper().eq((Object)"month", (Object)(month + "-01")));
        if (CollectionUtils.isNotEmpty((Collection)moutaiOutEntityList) && moutaiOutEntityList.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u6708\u4efd\u5df2\u6709\u5bf9\u5e94\u5355\u636e\uff01", (Object)moutaiOutVO);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.between((Object)"instore_date", (Object)(month + "-01"), (Object)(month + "-31"));
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List entityList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && entityList.size() > 0) {
            List detailList = this.instoreDetailService.list((Wrapper)new QueryWrapper().in((Object)"instore_id", (Collection)entityList.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            BigDecimal inNum = detailList.stream().filter(p -> p.getMaterialCategoryName() != null && "\u8305\u53f0".equals(p.getMaterialCategoryName())).map(InstoreDetailEntity::getInstoreNumber).reduce(BigDecimal.ZERO, BigDecimal::add);
            moutaiOutVO.setBottleInNum(inNum);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            moutaiOutVO.setMonth(simpleDateFormat.parse(month));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u6839\u636e\u6708\u4efd\u67e5\u8be2\u8305\u53f0\u5165\u5e93\u6570\u636e\u6210\u529f\uff01", (Object)moutaiOutVO);
    }
}

