/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.vo.CertRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"certRecord"})
public class CertRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_OA_ZSDA";
    @Autowired
    private ICertRecordService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertRecordVO> saveOrUpdate(@RequestBody CertRecordVO saveOrUpdateVO) {
        return this.service.insertOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertRecordVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertRecordVO> queryChangeDetail(Long id) {
        CertRecordVO changeVO = this.service.queryChangeDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertRecordVO> vos) {
        return this.service.deleteVos(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CertRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "humanPayName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("taskVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "humanPayName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("taskVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, CertRecordVO.class);
        Iterator iterator = voList.iterator();
        while (iterator.hasNext()) {
            CertRecordVO certRecordVO;
            certRecordVO.setSexName(1 == (certRecordVO = (CertRecordVO)iterator.next()).getSex() ? "\u7537" : "\u5973");
            certRecordVO.setChangeStateName(certRecordVO.getChangeState() == 0 ? "\u672a\u53d8\u66f4" : (certRecordVO.getChangeState() == 1 ? "\u53d8\u66f4\u4e2d" : "\u5df2\u53d8\u66f4"));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("CertRecord-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCertRecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CertRecordVO>> refCertRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().addAll(Arrays.asList("humanPayName", "humanTypeName", "phone", "idCard"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"CertRecordDetail-import.xlsx", (String)"\u5408\u540c\u767b\u8bb0-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }
}

