package com.ejianc.business.bid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bid.bean.MonthFeeApplyDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标管理-月度费用提成申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_month_fee_apply")
public class MonthFeeApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="month_date")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date monthDate; // 月份
    @TableField(value="employee_id")
    private Long employeeId; // 人员Id
    @TableField(value="employee_name")
    private String employeeName; // 人员名称
    @TableField(value="org_id")
    private Long orgId; // 人员所属组织Id
    @TableField(value="org_name")
    private String orgName; // 人员所属组织名称
    @TableField(value="mny")
    private BigDecimal mny; // 费用提成明细
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="un_pay_mny")
    private BigDecimal unPayMny; // 未支付金额
    @TableField(value="confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间
    @TableField(exist=false)
    @SubEntity(serviceName="monthFeeApplyDetailService")
    private List<MonthFeeApplyDetailEntity> monthFeeApplyDetailList = new ArrayList<>(); // 投标管理-月度费用提成申请详情

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getMonthDate() {
        return monthDate;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<MonthFeeApplyDetailEntity> getMonthFeeApplyDetailList() {
        return monthFeeApplyDetailList;
    }

    public void setMonthFeeApplyDetailList(List<MonthFeeApplyDetailEntity> monthFeeApplyDetailList) {
        this.monthFeeApplyDetailList = monthFeeApplyDetailList;
    }
}
