package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.constants.BidCommonContants;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.TenderFundsMapper;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.service.ITenderFundsService;

import java.util.Date;
import java.util.List;

/**
 * 投标管理-投标保证金
 * 
 * @author generator
 * 
 */
@Service("tenderFundsService")
public class TenderFundsServiceImpl extends BaseServiceImpl<TenderFundsMapper, TenderFundsEntity> implements ITenderFundsService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/tenderFunds/card?id=";

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IBusOpportunityService busOpportunityService;




    @Override
    public List<TenderFundsEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<TenderFundsEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");

        return super.list(query);
    }

    @Override
    public void saveQuoteBillId(Long id, Long quoteBillId) {
        TenderFundsEntity e  = super.selectById(id);
        e.setFundsBackId(null == quoteBillId ? Long.valueOf(BidCommonContants.STRING_NO) : quoteBillId);
        super.saveOrUpdate(e, false);
    }

    @Override
    public void delAllQuoteBillId(List<Long> quoteBillIds) {
        UpdateWrapper<TenderFundsEntity> update = new UpdateWrapper<>();
        update.in("funds_back_id", quoteBillIds);
        update.set("funds_back_id", Long.valueOf(BidCommonContants.STRING_NO));
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }

    @Override
    public void changeBusinessStatus(List<Long> ids, String status) {
        UpdateWrapper<TenderFundsEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("bounds_status", status);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());
        super.update(update);
    }

    @Override
    public void sendMsgToDocumenter(TenderFundsEntity entity) {
        logger.info("开始给资料员发送消息：----");
        String msg = this.sendMsg(entity, "投标保证金已付", entity.getEngineeringName() + "，投标保证金已付！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("开始给资料员发送消息异常：" + msg);
        }
        logger.info("开始给资料员发送消息结束！");
    }

    private String sendMsg(TenderFundsEntity entity, String subject, String content) {
        BusOpportunityEntity oppr = busOpportunityService.selectById(entity.getOpportunityId());
        String[] msgRecUserIds = new String[]{oppr.getDocumenterId().toString(), entity.getEmployeeId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
        msgParameter.setPcUrl(PC_URL + entity.getId());

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
