package com.ejianc.business.invest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.bean.ProjectRepaymentEntity;
import com.ejianc.business.invest.service.IPersonDebtService;
import com.ejianc.business.invest.service.IProjectDebtService;
import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;

@Service("projectDebt") 
public class ProjectDebtBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectRepaymentService projectRepaymentService;
	@Autowired
	private IProjectDebtService service;
	@Autowired
	private IPayRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		List<ProjectRepaymentEntity> projectRepaymentList = projectRepaymentService.list(new QueryWrapper<ProjectRepaymentEntity>().eq("project_debt_id", billId));
		if (CollectionUtils.isNotEmpty(projectRepaymentList) && projectRepaymentList.size() > 0){
			throw new BusinessException("当前单据已被下游业务-项目还款单还款单引用，不能弃审！");
		}
		ProjectDebtEntity entity = service.selectById(billId);
		if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0){
			return CommonResponse.error("该单据已支付不能弃审/撤回!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/

		ProjectDebtEntity entity = service.selectById(billId);
		entity.setPayMny(BigDecimal.ZERO);//支付金额
		entity.setUnPayMny(ComputeUtil.safeSub(entity.getDebtMny(),entity.getPayMny()));//未支付金额
		entity.setConfirmTimeRecord(null);
		service.updateById(entity);
		// 删除付款记录表
		recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));
		return CommonResponse.success();
	}

}
