/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.business.oa.bean.CarEntity;
import com.ejianc.business.oa.mapper.CarMapper;
import com.ejianc.business.oa.service.ICarService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="carService")
public class CarServiceImpl
extends BaseServiceImpl<CarMapper, CarEntity>
implements ICarService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private WarnFeignUtil feignUtil;

    private long getDiffDay(Date date1, Date date2) {
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long daysDifference = ChronoUnit.DAYS.between(localDate1, localDate2);
        return daysDifference;
    }

    @Override
    public CommonResponse checkWarn(HttpServletRequest request) {
        LambdaQueryWrapper lambdaAccountWrapper = new LambdaQueryWrapper();
        lambdaAccountWrapper.in(CarEntity::getBillState, new Object[]{1, 3});
        List carEntityList = super.list((Wrapper)lambdaAccountWrapper);
        Date date1 = new Date();
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        String formurl = this.baseHost + "ejc-bfyjerp-frontend/#/car/card?id=";
        for (CarEntity carEntity : carEntityList) {
            Date businessInsuranceDate;
            long diffDay3;
            Date trafficInsuranceDate;
            long diffDay2;
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(carEntity.getChargeId().toString());
            Date yearEndDate = carEntity.getYearEndDate();
            long diffDay = this.getDiffDay(date1, yearEndDate);
            if (diffDay == 30L) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("\u8f66\u724c\u53f7\u4e3a:" + carEntity.getCarNum() + "\u7684\u5e74\u68c0\u5230\u671f\u65f6\u95f4\u8fd8\u670930\u5929,\u8bf7\u60a8\u5173\u6ce8!");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '\"' + formurl + carEntity.getId() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
            if ((diffDay2 = this.getDiffDay(date1, trafficInsuranceDate = carEntity.getTrafficInsuranceDate())) == 30L) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("\u8f66\u724c\u53f7\u4e3a:" + carEntity.getCarNum() + "\u7684\u4ea4\u5f3a\u9669\u5230\u671f\u65f6\u95f4\u8fd8\u670930\u5929,\u8bf7\u60a8\u5173\u6ce8!");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '\"' + formurl + carEntity.getId() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
            if ((diffDay3 = this.getDiffDay(date1, businessInsuranceDate = carEntity.getBusinessInsuranceDate())) != 30L) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("\u8f66\u724c\u53f7\u4e3a:" + carEntity.getCarNum() + "\u7684\u5546\u4e1a\u9669\u5230\u671f\u65f6\u95f4\u8fd8\u670930\u5929,\u8bf7\u60a8\u5173\u6ce8!");
            String subject = buffer.toString();
            String content = subject + "<a href=" + '\"' + formurl + carEntity.getId() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
        }
        this.logger.info("\u6267\u884c\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }
}

