package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.OutstoreDetailEntity;
/**
 * 人力行政-物品出库单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_outstore")
public class OutstoreEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 出库组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 出库组织名称
    @TableField(value="out_store_id")
    private Long outStoreId; // 出库仓库id
    @TableField(value="out_store_name")
    private String outStoreName; // 出库仓库名称
    @TableField(value="out_date")
    private Date outDate; // 出库日期
    @TableField(value="use_for")
    private String useFor; // 用途
    @TableField(value="in_store_id")
    private Long inStoreId; // 调入仓库id
    @TableField(value="in_store_name")
    private String inStoreName; // 调入仓库名称
    @TableField(value="in_store_date")
    private Date inStoreDate; // 入库日期
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入组织id
    @TableField(value="in_org_code")
    private String inOrgCode; // 调入组织编码
    @TableField(value="in_org_name")
    private String inOrgName; // 调入组织名称
    @TableField(value="out_store_type")
    private Integer outStoreType; // 出库单类型：0-调拨出库 1-出库单
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="recipient_id")
    private Long recipientId; // 领用人
    @TableField(value="recipient_name")
    private String recipientName; // 领用人名称
    @TableField(value="dept_id")
    private Long deptId; // 部门
    @TableField(value="dept_name")
    private String deptName; // 部门
    
    @TableField(exist=false)
    @SubEntity(serviceName="outstoreDetailService", pidName = "outStoreId")
    private List<OutstoreDetailEntity> detailList = new ArrayList<>(); // 人力行政-物品出库单子表

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }
    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }
    public Date getInStoreDate() {
        return inStoreDate;
    }

    public void setInStoreDate(Date inStoreDate) {
        this.inStoreDate = inStoreDate;
    }
    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public Integer getOutStoreType() {
        return outStoreType;
    }

    public void setOutStoreType(Integer outStoreType) {
        this.outStoreType = outStoreType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }


    public List<OutstoreDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OutstoreDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Long getRecipientId() {
        return recipientId;
    }

    public void setRecipientId(Long recipientId) {
        this.recipientId = recipientId;
    }

    public String getRecipientName() {
        return recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }
}
