/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.service.ITenderFundsBackService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tenderFundsBack")
public class TenderFundsBackBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ITenderFundsBackService service;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        TenderFundsBackEntity e = (TenderFundsBackEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(new Date());
        e.setCommitUserCode(InvocationInfoProxy.getUsercode());
        e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TenderFundsBackEntity e = (TenderFundsBackEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(InvocationInfoProxy.getUsercode());
            e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        }
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TenderFundsBackEntity entity = (TenderFundsBackEntity)((Object)this.service.selectById(billId));
        if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u652f\u4ed8\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }

    private CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
        TenderFundsBackEntity e = (TenderFundsBackEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserCode(null);
        e.setEffectiveDate(null);
        e.setPayMny(BigDecimal.ZERO);
        e.setUnPayMny(ComputeUtil.safeSub((BigDecimal)e.getMny(), (BigDecimal)e.getPayMny()));
        e.setConfirmTime(null);
        this.service.saveOrUpdate((Object)e, false);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

