package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2024/11/11 20:20
 */
@TableName(value = "ejc_bid_month_fee_commission")
public class MonthFeeCommissionEntity extends BaseEntity {
    private static final long serialVersionUID = -6667665494407608570L;

    @TableField(value = "dept_name")
    private String deptName;//人员部门名称
    @TableField(value = "post_name")
    private String postName;//人员岗位名称
    @TableField(value = "employee_name")
    private String employeeName;//人员名称
    @TableField(value = "employee_id")
    private Long employeeId; //人员Id
    @TableField(value = "employee_code")
    private String employeeCode;//人员编码
    @TableField(value = "registration_mmy")
    private BigDecimal registrationMny;//报名提成
    @TableField(value = "file_mny")
    private BigDecimal fileMny;//资料提成
    @TableField(value = "auth_mny")
    private BigDecimal authMny;//授权提成
    @TableField(value = "budget_mny")
    private BigDecimal budgetMny;//预算提成
    @TableField(value = "bid_doc_mny")
    private BigDecimal bidDocMny;//标书提成
    @TableField(value = "total_mny")
    private BigDecimal totalMny; //总金额

    @TableField(value = "org_id")
    private Long orgId; //人员所属组织Id
    @TableField(value = "org_code")
    private String orgCode;  //人员所属组织编码
    @TableField(value = "org_name")
    private String orgName; //人员所属组织名称

    @TableField(value = "year")
    private String year;//年份
    @TableField(value = "month")
    private String month;//月度
    @TableField(value = "oppr_ids")
    private String opprIds;//来源商机ids(,分割)
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    @TableField(value = "bill_date")
    private Date billDate; // 生成日期
    @TableField(value = "registration_ids")
    private String registrationIds;//报名提成ids(,分割)
    @TableField(value = "file_ids")
    private String fileIds;//资料提成ids(,分割)
    @TableField(value = "auth_ids")
    private String authIds;//授权提成ids(,分割)
    @TableField(value = "budget_ids")
    private String budgetIds;//预算提成ids(,分割)
    @TableField(value = "bidDoc_ids")
    private String bidDocIds;//标书提成ids(,分割)

    public String getRegistrationIds() {
        return registrationIds;
    }

    public void setRegistrationIds(String registrationIds) {
        this.registrationIds = registrationIds;
    }

    public String getFileIds() {
        return fileIds;
    }

    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }

    public String getAuthIds() {
        return authIds;
    }

    public void setAuthIds(String authIds) {
        this.authIds = authIds;
    }

    public String getBudgetIds() {
        return budgetIds;
    }

    public void setBudgetIds(String budgetIds) {
        this.budgetIds = budgetIds;
    }

    public String getBidDocIds() {
        return bidDocIds;
    }

    public void setBidDocIds(String bidDocIds) {
        this.bidDocIds = bidDocIds;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getOpprIds() {
        return opprIds;
    }

    public void setOpprIds(String opprIds) {
        this.opprIds = opprIds;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public BigDecimal getRegistrationMny() {
        return registrationMny;
    }

    public void setRegistrationMny(BigDecimal registrationMny) {
        this.registrationMny = registrationMny;
    }

    public BigDecimal getFileMny() {
        return fileMny;
    }

    public void setFileMny(BigDecimal fileMny) {
        this.fileMny = fileMny;
    }

    public BigDecimal getAuthMny() {
        return authMny;
    }

    public void setAuthMny(BigDecimal authMny) {
        this.authMny = authMny;
    }

    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }

    public BigDecimal getBidDocMny() {
        return bidDocMny;
    }

    public void setBidDocMny(BigDecimal bidDocMny) {
        this.bidDocMny = bidDocMny;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
}
