package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.service.ITenderFundsBackService;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

@Service("tenderFundsBack") 
public class TenderFundsBackBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ITenderFundsBackService service;
	@Autowired
	private IPayRecordService recordService;
	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		TenderFundsBackEntity e = service.selectById(billId);
		e.setCommitDate(new Date());
		e.setCommitUserCode(InvocationInfoProxy.getUsercode());
		e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("提交审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TenderFundsBackEntity e = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(InvocationInfoProxy.getUsercode());
			e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		}

		//更新
		service.saveOrUpdate(e, false);

		return CommonResponse.success("终审审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TenderFundsBackEntity entity = service.selectById(billId);
		if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0){
			return CommonResponse.error("该单据已支付不能弃审/撤回!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBack(billId, state, billTypeCode);
	}

	private CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
		TenderFundsBackEntity e = service.selectById(billId);

		e.setCommitDate(null);
		e.setCommitUserCode(null);
		e.setCommitUserCode(null);
		e.setEffectiveDate(null);
		e.setPayMny(BigDecimal.ZERO);//支付金额
		e.setUnPayMny(ComputeUtil.safeSub(e.getMny(),e.getPayMny()));//未支付金额
		e.setConfirmTime(null);
		service.saveOrUpdate(e, false);

		// 删除付款记录表
		recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));
		return CommonResponse.success("操作成功！");
	}

}
