package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.finance.bean.DaypayEntity;
import com.ejianc.business.finance.service.IOccupyService;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CarMapper;
import com.ejianc.business.oa.bean.CarEntity;
import com.ejianc.business.oa.service.ICarService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 人力行政-车辆明细表
 * 
 * @author generator
 * 
 */
@Service("carService")
public class CarServiceImpl extends BaseServiceImpl<CarMapper, CarEntity> implements ICarService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private WarnFeignUtil feignUtil;

    private long getDiffDay(Date date1,Date date2){
        // 假设这是 Date2，这里设置为比 Date1 早 10 天的日期
        // 将 Date 转换为 LocalDate
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // 计算 localDate1 比 localDate2 多的天数
        long daysDifference = ChronoUnit.DAYS.between(localDate1, localDate2);
        return daysDifference;
    }

    @Override
    public CommonResponse checkWarn(HttpServletRequest request) {
        //查询审批通过的车辆明细
        LambdaQueryWrapper<CarEntity> lambdaAccountWrapper = new LambdaQueryWrapper<>();
        lambdaAccountWrapper.in(CarEntity::getBillState,1,3);
        List<CarEntity> carEntityList = super.list(lambdaAccountWrapper);
        Date date1 = new Date();
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        String formurl = baseHost + "ejc-bfyjerp-frontend/#/car/card?id=";
        for (CarEntity carEntity : carEntityList){
            List<String> sender = new ArrayList<>();
            sender.add(carEntity.getChargeId().toString());
            Date yearEndDate = carEntity.getYearEndDate();
            long diffDay = getDiffDay(date1, yearEndDate);
            if (diffDay == 30L){
                StringBuffer buffer = new StringBuffer();
                buffer.append("车牌号为:"+carEntity.getCarNum()+"的年检到期时间" + "还有30天,请您关注!");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '"' + formurl+carEntity.getId() + '"' + ">前往点击</a>";
                feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }

            //交强险到期时间
            Date trafficInsuranceDate = carEntity.getTrafficInsuranceDate();
            long diffDay2 = getDiffDay(date1, trafficInsuranceDate);
            if (diffDay2 == 30L){
                StringBuffer buffer = new StringBuffer();
                buffer.append("车牌号为:"+carEntity.getCarNum()+"的交强险到期时间" + "还有30天,请您关注!");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '"' + formurl+carEntity.getId() + '"' + ">前往点击</a>";
                feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
            //商业险到期时间
            Date businessInsuranceDate = carEntity.getBusinessInsuranceDate();
            long diffDay3 = getDiffDay(date1, businessInsuranceDate);
            if (diffDay3 == 30L){
                StringBuffer buffer = new StringBuffer();
                buffer.append("车牌号为:"+carEntity.getCarNum()+"的商业险到期时间" + "还有30天,请您关注!");
                String subject = buffer.toString();
                String content = subject + "<a href=" + '"' + formurl+carEntity.getId() + '"' + ">前往点击</a>";
                feignUtil.sendMsg(messageType, sender, "notice", subject, content, null);
            }
        }

        logger.info("执行成功！");
        return CommonResponse.success("执行成功！");
    }

}
