package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.bid.service.IBidPersonAffirmService;
import com.ejianc.business.bid.vo.BidPersonAffirmVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标管理-确认标书员
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("bidPersonAffirm")
public class BidPersonAffirmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_PERSON_AFFIRM";

    @Autowired
    private IBidPersonAffirmService service;

    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<BidPersonAffirmVO> dataList = new ArrayList<>();
        List<BidPersonAffirmEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, BidPersonAffirmVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<BidPersonAffirmVO> saveOrUpdate(@RequestBody BidPersonAffirmVO saveOrUpdateVO) {
        QueryWrapper queryWrapper = new QueryWrapper<BidPersonAffirmEntity>().eq("opportunity_id", saveOrUpdateVO.getOpportunityId());
        if (null != saveOrUpdateVO.getId()){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List oldBidPersonAffirmList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(oldBidPersonAffirmList) && oldBidPersonAffirmList.size() > 0){
            return CommonResponse.error("该工程已做确认标书员，请切换工程！");
        }

        Boolean sendFlag = false;
    	BidPersonAffirmEntity entity = BeanMapper.map(saveOrUpdateVO, BidPersonAffirmEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    	    sendFlag = true;
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }else {
            BidPersonAffirmEntity oldEntity = service.selectById(entity.getId());
            if (null != oldEntity && (oldEntity.getBidPersonId().longValue() != entity.getBidPersonId().longValue() || oldEntity.getBudgetPersonId().longValue() != entity.getBudgetPersonId())){
                sendFlag = true;
                service.sendMsgToInstallPerson(oldEntity);
            }
        }
    	service.saveOrUpdate(entity, false);
        if (sendFlag) {
            service.sendMsgToInstallPerson(entity);
        }
    	BidPersonAffirmVO vo = BeanMapper.map(entity, BidPersonAffirmVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BidPersonAffirmVO> queryDetail(Long id) {
    	BidPersonAffirmEntity entity = service.selectById(id);
    	BidPersonAffirmVO vo = BeanMapper.map(entity, BidPersonAffirmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidPersonAffirmVO> vos) {
        service.removeByIds(vos.stream().map(BidPersonAffirmVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BidPersonAffirmVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("bidPersonName");
        fuzzyFields.add("budgetPersonName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));


        IPage<BidPersonAffirmEntity> page = service.queryPage(param,false);
        IPage<BidPersonAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidPersonAffirmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("bidPersonName");
        fuzzyFields.add("budgetPersonName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BidPersonAffirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidPersonAffirm-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBidPersonAffirmData", method = RequestMethod.GET)
    public CommonResponse<IPage<BidPersonAffirmVO>> refBidPersonAffirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("bidPersonName");
        fuzzyFields.add("budgetPersonName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BidPersonAffirmEntity> page = service.queryPage(param,false);
        IPage<BidPersonAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidPersonAffirmVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
