package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.vo.BidOpenResultVO;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.BidServiceFeeEntity;
import com.ejianc.business.bid.service.IBidServiceFeeService;
import com.ejianc.business.bid.vo.BidServiceFeeVO;

/**
 * 投标管理-中标服务费
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("bidServiceFee")
public class BidServiceFeeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_SERVICE_FEE";
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IBidServiceFeeService service;

    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<BidServiceFeeVO> dataList = new ArrayList<>();
        List<BidServiceFeeEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, BidServiceFeeVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<BidServiceFeeVO> saveOrUpdate(@RequestBody BidServiceFeeVO saveOrUpdateVO) {
    	BidServiceFeeEntity entity = BeanMapper.map(saveOrUpdateVO, BidServiceFeeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }
    	service.saveOrUpdate(entity, false);
    	BidServiceFeeVO vo = BeanMapper.map(entity, BidServiceFeeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BidServiceFeeVO> queryDetail(Long id) {
    	BidServiceFeeEntity entity = service.selectById(id);
    	BidServiceFeeVO vo = BeanMapper.map(entity, BidServiceFeeVO.class);
        LambdaQueryWrapper<PayRecordEntity> lambda = Wrappers.<PayRecordEntity>lambdaQuery();
        lambda.eq(PayRecordEntity::getPayapplyId, id);
        lambda.orderByDesc(PayRecordEntity::getCreateTime);
        List<PayRecordEntity> list = payRecordService.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setPayRecordList(BeanMapper.mapList(list, PayRecordVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<BidServiceFeeVO> vos) {
        service.removeByIds(vos.stream().map(BidServiceFeeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BidServiceFeeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        IPage<BidServiceFeeEntity> page = service.queryPage(param,false);
        IPage<BidServiceFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidServiceFeeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BidServiceFeeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidServiceFee-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBidServiceFeeData", method = RequestMethod.GET)
    public CommonResponse<IPage<BidServiceFeeVO>> refBidServiceFeeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BidServiceFeeEntity> page = service.queryPage(param,false);
        IPage<BidServiceFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidServiceFeeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
