package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.finance.utils.WarnFeignUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("busOpportunity") 
public class BusOpportunityBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBusOpportunityService service;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private WarnFeignUtil feignUtil;
	@Autowired
	private IUserApi userApi;

	@Value("${common.env.base-host}")
	private String baseHost;
	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		BusOpportunityEntity e = service.selectById(billId);
		e.setCommitDate(new Date());
		e.setCommitUserCode(InvocationInfoProxy.getUsercode());
		e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("提交审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBack(billId, state, billTypeCode);
	}

	private CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
		logger.info("商机登记单据billId-{}, state-{}, billTypeCode-{}撤回事件处理", billId, state, billTypeCode);

		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode, billId);
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("商机登记已发生下游业务,不能弃审和撤回");
		}

		BusOpportunityEntity e = service.selectById(billId);
		e.setCommitDate(null);
		e.setCommitUserCode(null);
		e.setCommitUserCode(null);
		e.setEffectiveDate(null);
		service.saveOrUpdate(e, false);

		return CommonResponse.success("审批回退回调查成功！");
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		BusOpportunityEntity e = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(InvocationInfoProxy.getUsercode());
			e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		}

		//设置生效时间
		e.setEffectiveDate(new Date());
		List<String> pusherIds = new ArrayList<>();
//        //叶苗 李雪娇消息提醒
        pusherIds.add("921718090402631689");
        pusherIds.add("921718090574598175");
        pusherIds.add("1247777316689256450");
		//发送消息
		List<String> messageType = new ArrayList<>();
		messageType.add("sys");
		String formurl = baseHost + "ejc-bfyjerp-frontend/#/busOpportunity/card?id="+ e.getId();
		if (CollectionUtils.isNotEmpty(pusherIds)) {
			StringBuffer buffer = new StringBuffer();
			CommonResponse<UserVO> employeeData = userApi.queryUserByUserCode(e.getCreateUserCode());

			buffer.append(employeeData.getData().getUserName() + "填写的" + e.getEngineeringName() + "已审批通过，请及时确认标书员");
			String subject = buffer.toString();
			String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
			feignUtil.sendMsg(messageType, pusherIds, "notice", subject, content, null);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBack(billId, state, billTypeCode);
	}

}
