package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BusOpportunityMapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标管理-商机登记实体
 * 
 * @author generator
 * 
 */
@Service("busOpportunityService")
public class BusOpportunityServiceImpl extends BaseServiceImpl<BusOpportunityMapper, BusOpportunityEntity> implements IBusOpportunityService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-bfyjerp-frontend/#/busOpportunity/card?id=";

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public List<BusOpportunityEntity> getAllByRegistrationId(Long registrationId, Long id) {
        QueryWrapper<BusOpportunityEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != registrationId) {
            query.eq("registration_id", registrationId);
        }
        if(null != id) {
            query.ne("id", id);
        }
        return super.list(query);
    }

    @Override
    public List<BusOpportunityVO> getAllUnQuoteBill() {
        List<BusOpportunityVO> resp = new ArrayList<>();
        QueryWrapper<BusOpportunityEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        query.eq("report_quote_flag", "0");

        List<BusOpportunityEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, BusOpportunityVO.class);
        }

        return resp;
    }

    @Override
    public void updateQuoteFlag(List<Long> updateOpprIds, String quoteFlag) {
        UpdateWrapper<BusOpportunityEntity> update = new UpdateWrapper<>();
        update.in("id", updateOpprIds);
        update.set("report_quote_flag", quoteFlag);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }

    @Override
    public void sendMsgToDocumenter(BusOpportunityEntity entity) {
        logger.info("开始给资料员发送消息：----");
        String msg = this.sendMsg(entity, "资料员确认", entity.getEngineeringName() + "，项目报名！请确认！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("开始给资料员发送消息异常：" + msg);
        }
        logger.info("开始给资料员发送消息结束！");
    }

    private String sendMsg(BusOpportunityEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getDocumenterId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
        msgParameter.setPcUrl(PC_URL + entity.getId());

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
