package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-证书人员付款申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_pay")
public class CertPayEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="cert_human_id")
    private Long certHumanId; // 姓名id
    @TableField(value="cert_human_name")
    private String certHumanName; // 姓名
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="age")
    private Integer age; // 年龄
    @TableField(value="compatibility")
    private String compatibility; // 配合度
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 岗位ID
    @TableField(value="post_name")
    private String postName; // 岗位
    @TableField(value="birth_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    @TableField(value="graduate_school")
    private String graduateSchool; // 毕业院校
    @TableField(value="major")
    private String major; // 所学专业
    @TableField(value="human_type")
    private Integer humanType; // 人员类别1:内部2：外部
    @TableField(value="human_type_name")
    private String humanTypeName; // 人员类别1:内部2：外部
    @TableField(value="educated")
    private String educated; // 最高学历
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="id_address")
    private String idAddress; // 身份证地址
    @TableField(value="now_address")
    private String nowAddress; // 现居住地址
    @TableField(value="phone")
    private String phone; // 移动电话
    @TableField(value="email")
    private String email; // 邮箱
    @TableField(value="urgent_name")
    private String urgentName; // 紧急联系人姓名
    @TableField(value="urgent_relational")
    private String urgentRelational; // 紧急联系人关系
    @TableField(value="urgent_phone")
    private String urgentPhone; // 紧急联系人电话
    @TableField(value="in_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inDate; // 迁入时间
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束时间
    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    @TableField(value="cert_mny")
    private BigDecimal certMny; // 证书费用
    @TableField(value="pay_type")
    private Integer payType; // 付款方式
    @TableField(value="pay_type_name")
    private String payTypeName; // 付款方式
    @TableField(value="insured_flag")
    private Integer insuredFlag; // 是否缴纳保险
    @TableField(value="insured_flag_name")
    private String insuredFlagName; // 是否缴纳保险
    @TableField(value="title_query")
    private Integer titleQuery; // 是否网查
    @TableField(value="title_query_name")
    private String titleQueryName; // 是否网查
    @TableField(value="insured_type")
    private String insuredType; // 保险种类
    @TableField(value="insured_type_name")
    private String insuredTypeName; // 保险种类
    @TableField(value="cert_flag")
    private Integer certFlag; // 证件是否齐全
    @TableField(value="cert_flag_name")
    private String certFlagName; // 证件是否齐全
    @TableField(value="state")
    private Integer state; // 状态标识（0：离职，1：在职）
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="un_pay_mny")
    private BigDecimal unPayMny; // 未支付金额
    @TableField(value="confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间
    @TableField(value="account_name")
    private String accountName; // 个人名称
    @TableField(value="account_num")
    private String accountNum; // 个人账号
    @TableField(value="insured_begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredBeginDate; // 社保开始时间
    @TableField(value="insured_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredEndDate; // 社保结束时间

    public Date getInsuredBeginDate() {
        return insuredBeginDate;
    }

    public void setInsuredBeginDate(Date insuredBeginDate) {
        this.insuredBeginDate = insuredBeginDate;
    }

    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCertHumanId() {
        return certHumanId;
    }

    public void setCertHumanId(Long certHumanId) {
        this.certHumanId = certHumanId;
    }
    public String getCertHumanName() {
        return certHumanName;
    }

    public void setCertHumanName(String certHumanName) {
        this.certHumanName = certHumanName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    public String getCompatibility() {
        return compatibility;
    }

    public void setCompatibility(String compatibility) {
        this.compatibility = compatibility;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getIdAddress() {
        return idAddress;
    }

    public void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }
    public String getNowAddress() {
        return nowAddress;
    }

    public void setNowAddress(String nowAddress) {
        this.nowAddress = nowAddress;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
    public String getUrgentName() {
        return urgentName;
    }

    public void setUrgentName(String urgentName) {
        this.urgentName = urgentName;
    }
    public String getUrgentRelational() {
        return urgentRelational;
    }

    public void setUrgentRelational(String urgentRelational) {
        this.urgentRelational = urgentRelational;
    }
    public String getUrgentPhone() {
        return urgentPhone;
    }

    public void setUrgentPhone(String urgentPhone) {
        this.urgentPhone = urgentPhone;
    }
    public Date getInDate() {
        return inDate;
    }

    public void setInDate(Date inDate) {
        this.inDate = inDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getCertMny() {
        return certMny;
    }

    public void setCertMny(BigDecimal certMny) {
        this.certMny = certMny;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public Integer getTitleQuery() {
        return titleQuery;
    }

    public void setTitleQuery(Integer titleQuery) {
        this.titleQuery = titleQuery;
    }
    public String getTitleQueryName() {
        return titleQueryName;
    }

    public void setTitleQueryName(String titleQueryName) {
        this.titleQueryName = titleQueryName;
    }
    public String getInsuredType() {
        return insuredType;
    }

    public void setInsuredType(String insuredType) {
        this.insuredType = insuredType;
    }
    public String getInsuredTypeName() {
        return insuredTypeName;
    }

    public void setInsuredTypeName(String insuredTypeName) {
        this.insuredTypeName = insuredTypeName;
    }
    public Integer getCertFlag() {
        return certFlag;
    }

    public void setCertFlag(Integer certFlag) {
        this.certFlag = certFlag;
    }
    public String getCertFlagName() {
        return certFlagName;
    }

    public void setCertFlagName(String certFlagName) {
        this.certFlagName = certFlagName;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
