package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.oa.service.IInstoreDetailService;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import com.ejianc.business.oa.vo.PurchaseDetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.PurchaseDetailMapper;
import com.ejianc.business.oa.bean.PurchaseDetailEntity;
import com.ejianc.business.oa.service.IPurchaseDetailService;

import java.util.ArrayList;
import java.util.List;

/**
 * 人力行政-采购申请单子表
 * 
 * @author generator
 * 
 */
@Service("purchaseDetailService")
public class PurchaseDetailServiceImpl extends BaseServiceImpl<PurchaseDetailMapper, PurchaseDetailEntity> implements IPurchaseDetailService{

    @Autowired
    private PurchaseDetailMapper purchaseDetailMapper;
    @Autowired
    private IInstoreDetailService instoreDetailService;
    @Override
    public List<PurchaseDetailVO> selectDetailList(Long id ,Long orgId,Long storeId) {
        List<PurchaseDetailVO> resultList = new ArrayList<>();
        List<PurchaseDetailVO> purchaseDetailVOS = purchaseDetailMapper.selectDetailList(id,orgId);
        resultList.addAll(purchaseDetailVOS);
        IPage<InstoreDetailVO> instoreDetailVOIPage = instoreDetailService.queryStoreCanUseNumPageDataAll(null, null, null, storeId, 1, 10, id);
        if (CollectionUtils.isNotEmpty(instoreDetailVOIPage.getRecords())){
            if (CollectionUtils.isEmpty(purchaseDetailVOS)){
                resultList.add(new PurchaseDetailVO());
            }
            resultList.get(0).setSumNum(instoreDetailVOIPage.getRecords().get(0).getCanUseNumber());
        }
        return resultList;
    }
}
