/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import com.ejianc.business.bid.service.IProjectPersonAffirmService;
import com.ejianc.business.bid.vo.ProjectPersonAffirmVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectPersonAffirm"})
public class ProjectPersonAffirmController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_PROJECT_PERSON_AFFIRM";
    @Autowired
    private IProjectPersonAffirmService service;
    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value={"getByBusOpportunityId"})
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List dataList = new ArrayList();
        List<ProjectPersonAffirmEntity> list = this.service.getByBusOpportunityId(id);
        if (CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, ProjectPersonAffirmVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<ProjectPersonAffirmVO> saveOrUpdate(@RequestBody ProjectPersonAffirmVO saveOrUpdateVO) {
        List oldList;
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"opportunity_id", (Object)saveOrUpdateVO.getOpportunityId());
        if (null != saveOrUpdateVO.getId()) {
            queryWrapper.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(oldList = this.service.list((Wrapper)queryWrapper))) && oldList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5de5\u7a0b\u5df2\u505a\u786e\u8ba4\u9879\u76ee\u7ecf\u7406\u53ca\u6280\u672f\u8d1f\u8d23\u4eba\uff0c\u8bf7\u5207\u6362\u5de5\u7a0b\uff01");
        }
        ProjectPersonAffirmVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ProjectPersonAffirmVO> queryDetail(Long id) {
        ProjectPersonAffirmEntity entity = (ProjectPersonAffirmEntity)((Object)this.service.selectById(id));
        ProjectPersonAffirmVO vo = (ProjectPersonAffirmVO)BeanMapper.map((Object)((Object)entity), ProjectPersonAffirmVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ProjectPersonAffirmVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ProjectPersonAffirmVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String authOrgIds = this.sessionManager.getUserContext().getAuthOrgIds();
        ArrayList orgIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        } else {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            orgIds.addAll(((List)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId", new Parameter("in", orgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPersonAffirmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String authOrgIds = this.sessionManager.getUserContext().getAuthOrgIds();
        ArrayList orgIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        } else {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            orgIds.addAll(((List)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId", new Parameter("in", orgIds));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectPersonAffirm-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectPersonAffirmData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<ProjectPersonAffirmVO>> refProjectPersonAffirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPersonAffirmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

