package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.EmployeeIntoRecordEntity;
import com.ejianc.business.oa.bean.InsurancePaymentApplyEntity;
import com.ejianc.business.oa.bean.YearSalaryEntity;
import com.ejianc.business.oa.mapper.PayrollDetailMapper;
import com.ejianc.business.oa.mapper.PayrollMapper;
import com.ejianc.business.oa.service.*;
import com.ejianc.business.oa.service.impl.InsurancePaymentApplyServiceImpl;
import com.ejianc.business.oa.service.impl.PayrollServiceImpl;
import com.ejianc.business.oa.vo.EmployeeIntoRecordVO;
import com.ejianc.business.oa.vo.PayrollDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.vo.EmployeeIntoVO;

/**
 * 人力行政-员工入职审批表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("employeeInto")
public class EmployeeIntoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_RLXZ-YGRZSP";//此处需要根据实际修改

    @Autowired
    private IEmployeeIntoService service;
    @Autowired
    private IEmployeeIntoRecordService recordService;
    @Autowired
    private IInsurancePaymentApplyService insurancePaymentApplyService;
    @Autowired
    private PayrollServiceImpl payrollServiceImpl;
    @Autowired
    private IYearSalaryService yearSalaryService;
    @Autowired
    private PayrollMapper payrollMapper;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EmployeeIntoVO> saveOrUpdate(@RequestBody EmployeeIntoVO saveOrUpdateVO) {
    	EmployeeIntoEntity entity = BeanMapper.map(saveOrUpdateVO, EmployeeIntoEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (null==entity.getState()){
            entity.setState(1);
        }
        entity.setChangeStatus(1);
//        entity.setDeptId(entity.getOldDeptId());
//        entity.setDeptName(entity.getOldDeptName());
//        entity.setPostId(entity.getOldPostId());
//        entity.setPostName(entity.getOldPostName());
//        entity.setRank(entity.getOldRank());
//        entity.setRankName(entity.getOldRankName());
//        entity.setSalary(entity.getOldSalary());
//        entity.setBasicSalary(entity.getOldBasicSalary());
//        entity.setPostSalary(entity.getOldPostSalary());
//        entity.setLevelSalary(entity.getOldLevelSalary());
//        entity.setCertSalary(entity.getOldCertSalary());
//        entity.setEducatedSalary(entity.getOldEducatedSalary());
    	service.saveOrUpdate(entity, false);
    	EmployeeIntoVO vo = BeanMapper.map(entity, EmployeeIntoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EmployeeIntoVO> queryDetail(Long id) {
    	EmployeeIntoEntity entity = service.selectById(id);
    	EmployeeIntoVO vo = BeanMapper.map(entity, EmployeeIntoVO.class);
        if(null != vo) {
            if(3== vo.getChangeStatus()) {
                List<EmployeeIntoRecordVO> changeHisList = loadChangeHisList(vo.getId());
                vo.setChangeHisList(changeHisList);
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    private List<EmployeeIntoRecordVO> loadChangeHisList(Long employeeId) {
        List<EmployeeIntoRecordVO> resp = new ArrayList<>();
        QueryWrapper<EmployeeIntoRecordEntity> hisQuery = new QueryWrapper<>();
        hisQuery.eq("employee_id", employeeId);
        hisQuery.orderByDesc("create_time");

        List<EmployeeIntoRecordEntity> list = recordService.list(hisQuery);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, EmployeeIntoRecordVO.class);
        }
        return  resp;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EmployeeIntoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (EmployeeIntoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EmployeeIntoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EmployeeIntoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code","name"));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EmployeeIntoEntity> page = service.queryPage(param,false);
        IPage<EmployeeIntoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmployeeIntoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code","name"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EmployeeIntoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<EmployeeIntoVO> voList = BeanMapper.mapList(list, EmployeeIntoVO.class);
        for (EmployeeIntoVO employeeIntoVO : voList) {
            employeeIntoVO.setStateName(1==employeeIntoVO.getState()?"在职":"离职");
            employeeIntoVO.setChangeStatusName(1==employeeIntoVO.getChangeStatus()?"未变更":2==employeeIntoVO.getChangeStatus()?"变更中":"已变更");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("EmployeeInto-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refEmployeeIntoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EmployeeIntoVO>> refEmployeeIntoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getFuzzyFields().addAll(Arrays.asList("name", "orgName"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            //证书人员工资参照证书金额大于0的数据
            if (null!=_con.get("certSalaryFlag")){
                param.getParams().put("certSalary", new Parameter(QueryParam.GT, 0));
            }
        }

        IPage<EmployeeIntoEntity> page = service.queryPage(param,false);
        IPage<EmployeeIntoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmployeeIntoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * @Description queryList 查询公司员工华名册
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryEmployeeDataReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EmployeeIntoVO>> queryEmployeeDataReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name"));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EmployeeIntoEntity> page = service.queryPage(param,false);
        IPage<EmployeeIntoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EmployeeIntoVO> employeeIntoVOList = BeanMapper.mapList(page.getRecords(), EmployeeIntoVO.class);


        if (CollectionUtils.isNotEmpty(employeeIntoVOList) && employeeIntoVOList.size() > 0){
            List<Long> employeeIdList = employeeIntoVOList.stream().map(EmployeeIntoVO::getId).collect(Collectors.toList());
            //保险
            List<InsurancePaymentApplyEntity> insurancePaymentApplyList = insurancePaymentApplyService.list(new QueryWrapper<InsurancePaymentApplyEntity>().in("person_id", employeeIdList).in("bill_state", Arrays.asList(1,3)).orderByAsc("start_date"));
            Map<Long, Date> insuranceMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(insurancePaymentApplyList) && insurancePaymentApplyList.size() > 0){
                for (InsurancePaymentApplyEntity insurancePaymentApplyEntity : insurancePaymentApplyList) {
                    if (!insuranceMap.containsKey(insurancePaymentApplyEntity.getPersonId())){
                        insuranceMap.put(insurancePaymentApplyEntity.getPersonId(), insurancePaymentApplyEntity.getStartDate());
                    }
                }
            }


            //异动
            Map<Long, EmployeeIntoVO> employeeChangeMap = new HashMap<>();
            List<EmployeeIntoVO> employeeChangeList = service.queryEmployeeChangeData(employeeIdList);
            if (CollectionUtils.isNotEmpty(employeeChangeList) && employeeChangeList.size() > 0){
                employeeChangeMap = employeeChangeList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }


            List<String> idCardList = employeeIntoVOList.stream().map(EmployeeIntoVO::getIdCard).collect(Collectors.toList());
            //证书信息
            Map<String, String> employeeCertMap = new HashMap<>();
            List<EmployeeIntoVO> employeeCertList = service.queryEmployeeCertData(idCardList);
            if (CollectionUtils.isNotEmpty(employeeCertList) && employeeCertList.size() > 0){
                employeeCertMap = employeeCertList.stream().collect(Collectors.toMap(item -> item.getIdCard(), item -> item.getCertName()));
            }
            //查询司龄档案信息
            LambdaQueryWrapper<YearSalaryEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(YearSalaryEntity::getDr,0);
            List<YearSalaryEntity> yearSalaryEntityList = yearSalaryService.list(lambdaQueryWrapper);
            Map<Integer, Map<String, BigDecimal>> yearMap = yearSalaryEntityList.stream().collect(Collectors.groupingBy(YearSalaryEntity::getRank
                    , Collectors.toMap(YearSalaryEntity::getYear, YearSalaryEntity::getSalary, (existing, replacement) -> replacement)));
            List<PayrollDetailVO> lastDetailList = payrollMapper.queryAllLastDetail();
            Map<String, PayrollDetailVO> lastDetailMap = lastDetailList.stream().filter(item->null!=item.getIdCard()&&null!=item.getYearSalary()).collect(Collectors.toMap(PayrollDetailVO::getIdCard, Function.identity()
                    , (existing, replacement) -> replacement));
            //劳务信息
            Map<Long, EmployeeIntoVO> employeeLaborMap = new HashMap<>();
            List<EmployeeIntoVO> employeeLaborList = service.queryEmployeeLaborData(employeeIdList);
            if (CollectionUtils.isNotEmpty(employeeLaborList) && employeeLaborList.size() > 0){
                employeeLaborMap = employeeLaborList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }



            for (EmployeeIntoVO employeeIntoVO : employeeIntoVOList) {
                employeeIntoVO.setInsuredStartDate(insuranceMap.get(employeeIntoVO.getId()));
                if (employeeChangeMap.containsKey(employeeIntoVO.getId())){
                    employeeIntoVO.setEmployeeChangeNum(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeNum());
                    employeeIntoVO.setEmployeeChangeTime(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeTime());
                    employeeIntoVO.setEmployeeChangeType(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeType());
                }
                if (employeeCertMap.containsKey(employeeIntoVO.getIdCard())){
                    employeeIntoVO.setCertName(employeeCertMap.get(employeeIntoVO.getIdCard()));
                }else {
                    employeeIntoVO.setCertName(null);
                }
                if (employeeLaborMap.containsKey(employeeIntoVO.getId())){
                    employeeIntoVO.setFirstSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getFirstSignTime());
                    employeeIntoVO.setFirstEndTime(employeeLaborMap.get(employeeIntoVO.getId()).getFirstEndTime());
                    employeeIntoVO.setSecondSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getSecondSignTime());
                    employeeIntoVO.setSecondEndTIme(employeeLaborMap.get(employeeIntoVO.getId()).getSecondEndTIme());
                    if (null != employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime()){
                        employeeIntoVO.setThirdSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime().getTime() == employeeLaborMap.get(employeeIntoVO.getId()).getSecondSignTime().getTime() ? null : employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime());
                        employeeIntoVO.setThirdEndTime(employeeLaborMap.get(employeeIntoVO.getId()).getThirdEndTime().getTime() == employeeLaborMap.get(employeeIntoVO.getId()).getSecondEndTIme().getTime() ? null : employeeLaborMap.get(employeeIntoVO.getId()).getThirdEndTime());
                    }
                }
                employeeIntoVO.setYearSalary(payrollServiceImpl.calYearSalary(null,employeeIntoVO,DateFormatUtil.formatDate("yyyy-MM-dd",new Date()),yearMap,lastDetailMap));
                employeeIntoVO.setYearNum(payrollServiceImpl.calYearNumber(employeeIntoVO, DateFormatUtil.formatDate("yyyy-MM-dd",new Date())));
                employeeIntoVO.setSmallCollect(ComputeUtil.safeAdd(employeeIntoVO.getBasicSalary(), employeeIntoVO.getPostSalary(), employeeIntoVO.getLevelSalary(),employeeIntoVO.getOtherNeedPay()));
                employeeIntoVO.setAllCollect(ComputeUtil.safeAdd(employeeIntoVO.getSmallCollect(), employeeIntoVO.getSportSalary(), employeeIntoVO.getYearSalary(), employeeIntoVO.getEducatedSalary(), employeeIntoVO.getCertSalary()));

            }
        }
        pageData.setRecords(employeeIntoVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }




    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelEmployeeDataReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelEmployeeDataReport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EmployeeIntoEntity> page = service.queryPage(param,false);
        List<EmployeeIntoVO> employeeIntoVOList = BeanMapper.mapList(page.getRecords(), EmployeeIntoVO.class);


        if (CollectionUtils.isNotEmpty(employeeIntoVOList) && employeeIntoVOList.size() > 0){
            List<Long> employeeIdList = employeeIntoVOList.stream().map(EmployeeIntoVO::getId).collect(Collectors.toList());
            //保险
            List<InsurancePaymentApplyEntity> insurancePaymentApplyList = insurancePaymentApplyService.list(new QueryWrapper<InsurancePaymentApplyEntity>().in("person_id", employeeIdList).in("bill_state", Arrays.asList(1,3)).orderByAsc("start_date"));
            Map<Long, Date> insuranceMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(insurancePaymentApplyList) && insurancePaymentApplyList.size() > 0){
                for (InsurancePaymentApplyEntity insurancePaymentApplyEntity : insurancePaymentApplyList) {
                    if (!insuranceMap.containsKey(insurancePaymentApplyEntity.getPersonId())){
                        insuranceMap.put(insurancePaymentApplyEntity.getPersonId(), insurancePaymentApplyEntity.getStartDate());
                    }
                }
            }


            //异动
            Map<Long, EmployeeIntoVO> employeeChangeMap = new HashMap<>();
            List<EmployeeIntoVO> employeeChangeList = service.queryEmployeeChangeData(employeeIdList);
            if (CollectionUtils.isNotEmpty(employeeChangeList) && employeeChangeList.size() > 0){
                employeeChangeMap = employeeChangeList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }


            List<String> idCardList = employeeIntoVOList.stream().map(EmployeeIntoVO::getIdCard).collect(Collectors.toList());
            //证书信息
            Map<String, String> employeeCertMap = new HashMap<>();
            List<EmployeeIntoVO> employeeCertList = service.queryEmployeeCertData(idCardList);
            if (CollectionUtils.isNotEmpty(employeeCertList) && employeeCertList.size() > 0){
                employeeCertMap = employeeCertList.stream().collect(Collectors.toMap(item -> item.getIdCard(), item -> item.getCertName()));
            }
            //查询司龄档案信息
            LambdaQueryWrapper<YearSalaryEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(YearSalaryEntity::getDr,0);
            List<YearSalaryEntity> yearSalaryEntityList = yearSalaryService.list(lambdaQueryWrapper);
            Map<Integer, Map<String, BigDecimal>> yearMap = yearSalaryEntityList.stream().collect(Collectors.groupingBy(YearSalaryEntity::getRank
                    , Collectors.toMap(YearSalaryEntity::getYear, YearSalaryEntity::getSalary, (existing, replacement) -> replacement)));
            List<PayrollDetailVO> lastDetailList = payrollMapper.queryAllLastDetail();
            Map<String, PayrollDetailVO> lastDetailMap = lastDetailList.stream().filter(item->null!=item.getIdCard()&&null!=item.getYearSalary()).collect(Collectors.toMap(PayrollDetailVO::getIdCard, Function.identity()
                    , (existing, replacement) -> replacement));
            //劳务信息
            Map<Long, EmployeeIntoVO> employeeLaborMap = new HashMap<>();
            List<EmployeeIntoVO> employeeLaborList = service.queryEmployeeLaborData(employeeIdList);
            if (CollectionUtils.isNotEmpty(employeeLaborList) && employeeLaborList.size() > 0){
                employeeLaborMap = employeeLaborList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }



            for (EmployeeIntoVO employeeIntoVO : employeeIntoVOList) {
                if (null != employeeIntoVO.getSex()) {
                    employeeIntoVO.setSexName(1 == employeeIntoVO.getSex() ? "男" : "女");
                }
                employeeIntoVO.setInsuredStartDate(insuranceMap.get(employeeIntoVO.getId()));
                if (employeeChangeMap.containsKey(employeeIntoVO.getId())){
                    employeeIntoVO.setEmployeeChangeNum(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeNum());
                    employeeIntoVO.setEmployeeChangeTime(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeTime());
                    employeeIntoVO.setEmployeeChangeType(employeeChangeMap.get(employeeIntoVO.getId()).getEmployeeChangeType());
                }
                if (employeeCertMap.containsKey(employeeIntoVO.getIdCard())){
                    employeeIntoVO.setCertName(employeeCertMap.get(employeeIntoVO.getIdCard()));
                }else {
                    employeeIntoVO.setCertName(null);
                }
                if (employeeLaborMap.containsKey(employeeIntoVO.getId())){
                    employeeIntoVO.setFirstSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getFirstSignTime());
                    employeeIntoVO.setFirstEndTime(employeeLaborMap.get(employeeIntoVO.getId()).getFirstEndTime());
                    employeeIntoVO.setSecondSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getSecondSignTime());
                    employeeIntoVO.setSecondEndTIme(employeeLaborMap.get(employeeIntoVO.getId()).getSecondEndTIme());
                    if (null != employeeLaborMap.get(employeeIntoVO.getId()) && null != employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime()){
                        employeeIntoVO.setThirdSignTime(employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime().getTime() == employeeLaborMap.get(employeeIntoVO.getId()).getSecondSignTime().getTime() ? null : employeeLaborMap.get(employeeIntoVO.getId()).getThirdSignTime());
                        employeeIntoVO.setThirdEndTime(employeeLaborMap.get(employeeIntoVO.getId()).getThirdEndTime().getTime() == employeeLaborMap.get(employeeIntoVO.getId()).getSecondEndTIme().getTime() ? null : employeeLaborMap.get(employeeIntoVO.getId()).getThirdEndTime());
                    }
                }
                employeeIntoVO.setYearSalary(payrollServiceImpl.calYearSalary(null,employeeIntoVO,DateFormatUtil.formatDate("yyyy-MM-dd",new Date()),yearMap,lastDetailMap));
                employeeIntoVO.setYearNum(payrollServiceImpl.calYearNumber(employeeIntoVO, DateFormatUtil.formatDate("yyyy-MM-dd",new Date())));
                employeeIntoVO.setSmallCollect(ComputeUtil.safeAdd(employeeIntoVO.getBasicSalary(), employeeIntoVO.getPostSalary(), employeeIntoVO.getLevelSalary(),employeeIntoVO.getOtherNeedPay()));
                employeeIntoVO.setAllCollect(ComputeUtil.safeAdd(employeeIntoVO.getSmallCollect(), employeeIntoVO.getSportSalary(), employeeIntoVO.getYearSalary(), employeeIntoVO.getEducatedSalary(), employeeIntoVO.getCertSalary()));

            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", employeeIntoVOList);
        ExcelExport.getInstance().exportWithTrans("EmployeeDataReport-export.xlsx", beans, response);
    }
}
