/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.CategoryDocEntity;
import com.ejianc.business.finance.service.ICategoryDocService;
import com.ejianc.business.finance.vo.CategoryDocVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"categoryDoc"})
public class CategoryDocController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_BXFL_CODE";
    @Autowired
    private ICategoryDocService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CategoryDocVO> saveOrUpdate(@RequestBody CategoryDocVO saveOrUpdateVO) {
        CategoryDocEntity entity = (CategoryDocEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CategoryDocEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            Object billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode((BillCodeParam)billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getCostType()) {
            switch (entity.getCostType().toString()) {
                case "1": {
                    entity.setCostTypeName("\u5b9e\u5730\u8003\u5bdf\u8d39");
                    break;
                }
                case "2": {
                    entity.setCostTypeName("\u4e2d\u95f4\u8d39\u7528");
                    break;
                }
                case "3": {
                    entity.setCostTypeName("\u652f\u4ed8\u503a\u6743\u5bf9\u4ef7");
                    break;
                }
                case "4": {
                    entity.setCostTypeName("\u8d22\u52a1\u6210\u672c");
                    break;
                }
                case "5": {
                    entity.setCostTypeName("\u53f8\u6cd5\u8d39\u7528");
                    break;
                }
                case "6": {
                    entity.setCostTypeName("\u7a0e\u91d1");
                    break;
                }
                case "7": {
                    entity.setCostTypeName("\u63d0\u6210\u53ca\u5956\u52b1");
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CategoryDocVO vo = (CategoryDocVO)BeanMapper.map((Object)((Object)entity), CategoryDocVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CategoryDocVO> queryDetail(Long id) {
        CategoryDocEntity entity = (CategoryDocEntity)((Object)this.service.selectById(id));
        CategoryDocVO vo = (CategoryDocVO)BeanMapper.map((Object)((Object)entity), CategoryDocVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CategoryDocVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CategoryDocVO categoryDocVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CategoryDocVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CategoryDocVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, CategoryDocVO.class);
            resList.forEach(e -> {
                if ("1".equals(e.getProjectType())) {
                    e.setProjectTypeName("\u9879\u76ee");
                } else {
                    e.setProjectTypeName("\u516c\u53f8");
                }
                if (0 == e.getState()) {
                    e.setStateName("\u505c\u7528");
                } else {
                    e.setStateName("\u542f\u7528");
                }
                switch (e.getCostType().toString()) {
                    case "1": {
                        e.setCostTypeName("\u5b9e\u5730\u8003\u5bdf\u8d39");
                        break;
                    }
                    case "2": {
                        e.setCostTypeName("\u4e2d\u95f4\u8d39\u7528");
                        break;
                    }
                    case "3": {
                        e.setCostTypeName("\u652f\u4ed8\u503a\u6743\u5bf9\u4ef7");
                        break;
                    }
                    case "4": {
                        e.setCostTypeName("\u8d22\u52a1\u6210\u672c");
                        break;
                    }
                    case "5": {
                        e.setCostTypeName("\u53f8\u6cd5\u8d39\u7528");
                        break;
                    }
                    case "6": {
                        e.setCostTypeName("\u7a0e\u91d1");
                        break;
                    }
                    case "7": {
                        e.setCostTypeName("\u63d0\u6210\u53ca\u5956\u52b1");
                    }
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-CategoryDoc-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCategoryDocData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CategoryDocVO>> refCategoryDocData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("oneCategory");
        param.getFuzzyFields().add("twoCategory");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("contentCategory");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        param.getParams().put("categoryStatus", new Parameter("eq", (Object)1));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectType")) {
            String projectType = String.valueOf(_con.get((Object)"projectType"));
            param.getParams().put("projectType", new Parameter("eq", (Object)projectType));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CategoryDocVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam(required=false) Integer pageNumber, @RequestParam(required=false) Integer pageSize, @RequestParam(required=false) String condition) {
        JSONObject _con;
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        queryParam.setOrderMap(orderMap);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("state", new Parameter("eq", (Object)1));
        queryParam.getParams().put("categoryStatus", new Parameter("eq", (Object)1));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectType")) {
            String projectType = String.valueOf(_con.get((Object)"projectType"));
            queryParam.getParams().put("projectType", new Parameter("eq", (Object)projectType));
        }
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        List<Object> havChildIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            List ids = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("categoryStatus", new Parameter("eq", (Object)2));
            queryParam1.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam1.getParams().put("state", new Parameter("eq", (Object)1));
            queryParam1.getParams().put("oneCategoryId", new Parameter("in", ids));
            List havChildData = this.service.queryList(queryParam1, false);
            havChildIds = havChildData.stream().map(CategoryDocEntity::getOneCategoryId).collect(Collectors.toList());
        }
        for (CategoryDocEntity entity : dataList) {
            if (!havChildIds.contains(entity.getId())) continue;
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getOneCategory() + "-" + entity.getBillCode());
            map.put("code", entity.getBillCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CategoryDocVO>> refdata(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("oneCategory");
        fuzzyFields.add("twoCategory");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contentCategory");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("state", new Parameter("eq", (Object)1));
        Map param = queryParam.getParams();
        if (!StringUtils.isEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            param.put("oneCategoryId", new Parameter("eq", (Object)pid));
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Object list = null;
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CategoryDocVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", (Object)pageData);
    }
}

