/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.invest.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.service.IProjectDebtService;
import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectDebt")
public class ProjectDebtBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectRepaymentService projectRepaymentService;
    @Autowired
    private IProjectDebtService service;
    @Autowired
    private IPayRecordService recordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List projectRepaymentList = this.projectRepaymentService.list((Wrapper)new QueryWrapper().eq((Object)"project_debt_id", (Object)billId));
        if (CollectionUtils.isNotEmpty((Collection)projectRepaymentList) && projectRepaymentList.size() > 0) {
            throw new BusinessException("\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1-\u9879\u76ee\u8fd8\u6b3e\u5355\u8fd8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        ProjectDebtEntity entity = (ProjectDebtEntity)((Object)this.service.selectById(billId));
        if (null != entity.getPayMny() && entity.getPayMny().compareTo(BigDecimal.ZERO) > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u652f\u4ed8\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectDebtEntity entity = (ProjectDebtEntity)((Object)this.service.selectById(billId));
        entity.setPayMny(BigDecimal.ZERO);
        entity.setUnPayMny(ComputeUtil.safeSub((BigDecimal)entity.getDebtMny(), (BigDecimal)entity.getPayMny()));
        entity.setConfirmTimeRecord(null);
        this.service.updateById((Object)entity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        return CommonResponse.success();
    }
}

