package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.service.ITenderFundsService;
import com.ejianc.business.bid.vo.TenderFundsVO;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.TenderFundsBackEntity;
import com.ejianc.business.bid.service.ITenderFundsBackService;
import com.ejianc.business.bid.vo.TenderFundsBackVO;

/**
 * 投标管理-投标保证金退还
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("tenderFundsBack")
public class TenderFundsBackController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayRecordService payRecordService;
    private static final String BILL_CODE = "BID_TENDER_FUNDS_BACK";

    @Autowired
    private ITenderFundsBackService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ITenderFundsService tenderFundsService;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<TenderFundsBackVO> dataList = new ArrayList<>();
        List<TenderFundsBackEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, TenderFundsBackVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<TenderFundsBackVO> saveOrUpdate(@RequestBody TenderFundsBackVO saveOrUpdateVO) {
        TenderFundsEntity tenderFundsEntity = tenderFundsService.selectById(saveOrUpdateVO.getTenderFundsId());

        TenderFundsBackEntity entity = BeanMapper.map(saveOrUpdateVO, TenderFundsBackEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
            entity.setId(IdWorker.getId());
        }

        if(null != tenderFundsEntity.getFundsBackId() && tenderFundsEntity.getFundsBackId() != 0 && !tenderFundsEntity.getFundsBackId().equals(entity.getId())) {
            return CommonResponse.error("操作失败，保证金申请已被引用！");
        }


        TenderFundsBackVO vo = service.saveTenderFundsBack(entity);

        if (null != entity.getAccountRegisterId()){
            service.sendMsgToDocumenter(entity);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<TenderFundsBackVO> queryDetail(Long id) {
    	TenderFundsBackEntity entity = service.selectById(id);
    	TenderFundsBackVO vo = BeanMapper.map(entity, TenderFundsBackVO.class);
        LambdaQueryWrapper<PayRecordEntity> lambda = Wrappers.<PayRecordEntity>lambdaQuery();
        lambda.eq(PayRecordEntity::getPayapplyId, id);
        lambda.orderByDesc(PayRecordEntity::getCreateTime);
        List<PayRecordEntity> list = payRecordService.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setPayRecordList(BeanMapper.mapList(list, PayRecordVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<TenderFundsBackVO> vos) {
        service.deleteAllByIds(vos.stream().map(TenderFundsBackVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderFundsBackVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));


        IPage<TenderFundsBackEntity> page = service.queryPage(param,false);
        IPage<TenderFundsBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderFundsBackVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<TenderFundsBackEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TenderFundsBack-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refTenderFundsBackData", method = RequestMethod.GET)
    public CommonResponse<IPage<TenderFundsBackVO>> refTenderFundsBackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TenderFundsBackEntity> page = service.queryPage(param,false);
        IPage<TenderFundsBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderFundsBackVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
