package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.ProjectRegistrationAffirmEntity;
import com.ejianc.business.bid.vo.ProjectRegistrationAffirmVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.WinningRegistrationEntity;
import com.ejianc.business.bid.service.IWinningRegistrationService;
import com.ejianc.business.bid.vo.WinningRegistrationVO;

/**
 * 投标管理-中标登记
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("winningRegistration")
public class WinningRegistrationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "WINNING_REGISTRATION";

    @Autowired
    private IWinningRegistrationService service;

    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<WinningRegistrationVO> dataList = new ArrayList<>();
        List<WinningRegistrationEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, WinningRegistrationVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<WinningRegistrationVO> saveOrUpdate(@RequestBody WinningRegistrationVO saveOrUpdateVO) {
        QueryWrapper queryWrapper = new QueryWrapper<WinningRegistrationEntity>().eq("opportunity_id", saveOrUpdateVO.getOpportunityId());
        if (null != saveOrUpdateVO.getId()){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List oldList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(oldList) && oldList.size() > 0){
            return CommonResponse.error("该项目已做中标登记，请切换项目！");
        }

    	WinningRegistrationEntity entity = BeanMapper.map(saveOrUpdateVO, WinningRegistrationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }
    	service.saveOrUpdate(entity, false);
    	WinningRegistrationVO vo = BeanMapper.map(entity, WinningRegistrationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<WinningRegistrationVO> queryDetail(Long id) {
    	WinningRegistrationEntity entity = service.selectById(id);
    	WinningRegistrationVO vo = BeanMapper.map(entity, WinningRegistrationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<WinningRegistrationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WinningRegistrationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WinningRegistrationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<WinningRegistrationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        IPage<WinningRegistrationEntity> page = service.queryPage(param,false);
        IPage<WinningRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WinningRegistrationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        List<WinningRegistrationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WinningRegistration-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refWinningRegistrationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WinningRegistrationVO>> refWinningRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WinningRegistrationEntity> page = service.queryPage(param,false);
        IPage<WinningRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WinningRegistrationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
