/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BidServiceFeeEntity;
import com.ejianc.business.bid.service.IBidServiceFeeService;
import com.ejianc.business.bid.vo.BidServiceFeeVO;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bidServiceFee"})
public class BidServiceFeeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_SERVICE_FEE";
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IBidServiceFeeService service;
    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value={"getByBusOpportunityId"})
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List dataList = new ArrayList();
        List<BidServiceFeeEntity> list = this.service.getByBusOpportunityId(id);
        if (CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, BidServiceFeeVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<BidServiceFeeVO> saveOrUpdate(@RequestBody BidServiceFeeVO saveOrUpdateVO) {
        BidServiceFeeEntity entity = (BidServiceFeeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidServiceFeeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        BidServiceFeeVO vo = (BidServiceFeeVO)BeanMapper.map((Object)((Object)entity), BidServiceFeeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<BidServiceFeeVO> queryDetail(Long id) {
        BidServiceFeeEntity entity = (BidServiceFeeEntity)((Object)this.service.selectById(id));
        BidServiceFeeVO vo = (BidServiceFeeVO)BeanMapper.map((Object)((Object)entity), BidServiceFeeVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayRecordEntity::getPayapplyId, (Object)id);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List list = this.payRecordService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setPayRecordList(BeanMapper.mapList((Iterable)list, PayRecordVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<BidServiceFeeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<BidServiceFeeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String authOrgIds = this.sessionManager.getUserContext().getAuthOrgIds();
        ArrayList orgIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        } else {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            orgIds.addAll(((List)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId", new Parameter("in", orgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidServiceFeeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String authOrgIds = this.sessionManager.getUserContext().getAuthOrgIds();
        ArrayList orgIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        } else {
            orgIds.addAll(((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            orgIds.addAll(((List)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId", new Parameter("in", orgIds));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidServiceFee-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBidServiceFeeData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<BidServiceFeeVO>> refBidServiceFeeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("payAccountName");
        fuzzyFields.add("payAccount");
        fuzzyFields.add("payAccountOpenBankName");
        fuzzyFields.add("transferPerson");
        fuzzyFields.add("transferAccount");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidServiceFeeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

