/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl
extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity>
implements IInvoiceReceiveRegistService {
    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "BFYJ_TAX_RECEIVE_POOL";
    @Autowired
    private IBillCodeApi billCodeApi;
    private IOrgApi iOrgApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IDefdocApi defdocApi;
    private static final String BILL_CODE = "BFYJ_TAX_RECEIVE_REGIST";

    @Override
    public Boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getContractId() && this.checkContractId(entity)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u6709\u6536\u7968\u767b\u8bb0\uff0c\u8bf7\u5207\u6362\u5408\u540c\uff01");
        }
        if (this.checkProjectSellerId(entity)) {
            throw new BusinessException("\u8be5\u9879\u76ee+\u4f9b\u5e94\u5546\u5df2\u6709\u6536\u7968\u767b\u8bb0\uff0c\u8bf7\u5207\u6362\u4f9b\u5e94\u5546\uff01");
        }
        int passNum = 0;
        if (ListUtil.isNotEmpty(entity.getInvoiceReceivePoolList())) {
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("bfyj-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            this.checkPool(entity.getInvoiceReceivePoolList());
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceivePoolList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    poolEntity.setBillCode((String)billCode.getData());
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)poolEntity), (String[])new String[]{"invoiceType", "invoiceTypeName"});
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                if (1 == poolEntity.getPassFlag() && !"del".equals(poolEntity.getRowState())) {
                    ++passNum;
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType() + ""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(0);
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setOrgCode(entity.getOrgCode());
                poolEntity.setParentOrgId(entity.getParentOrgId());
                poolEntity.setParentOrgCode(entity.getParentOrgCode());
                poolEntity.setParentOrgName(entity.getParentOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            }
        }
        if (passNum > 0) {
            entity.setPassBoolean(1);
        } else {
            entity.setPassBoolean(0);
        }
        return super.saveOrUpdateNoES((Object)entity);
    }

    private boolean checkProjectSellerId(InvoiceReceiveRegistEntity entity) {
        List list;
        QueryWrapper entityQueryWrapper = new QueryWrapper();
        entityQueryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        entityQueryWrapper.eq((Object)"seller_id", (Object)entity.getSellerId());
        entityQueryWrapper.notIn((Object)"bill_state", Arrays.asList(1, 3));
        entityQueryWrapper.isNull((Object)"contract_id");
        if (null != entity.getId()) {
            entityQueryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        return CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)entityQueryWrapper))) && list.size() > 0;
    }

    private boolean checkContractId(InvoiceReceiveRegistEntity entity) {
        List list;
        QueryWrapper entityQueryWrapper = new QueryWrapper();
        entityQueryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        entityQueryWrapper.notIn((Object)"bill_state", Arrays.asList(1, 3));
        if (null != entity.getId()) {
            entityQueryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        return CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)entityQueryWrapper))) && list.size() > 0;
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        ArrayList<String> invoiceNumberList = new ArrayList<String>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            String invoiceNumber;
            if ("del".equals(vo.getRowState()) || !StringUtils.isNotEmpty((String)(invoiceNumber = vo.getInvoiceNumber()))) continue;
            if (invoiceNumberList.contains(invoiceNumber)) {
                throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + invoiceNumber + "\u3011\u5f55\u5165\u91cd\u590d\uff01");
            }
            invoiceNumberList.add(invoiceNumber);
            LambdaQueryWrapper invoiceNumberQueryWrapper = new LambdaQueryWrapper();
            invoiceNumberQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, (Object)invoiceNumber);
            invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, (Object)vo.getReceiveBillId());
            int count = this.invoiceReceivePoolService.count((Wrapper)invoiceNumberQueryWrapper);
            if (count <= 0) continue;
            throw new BusinessException("\u53d1\u7968\u53f7\u7801\u3010" + vo.getInvoiceNumber() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }
}

