package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayFlowVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 出纳资金-合同付款申请
 * 
 * @author generator
 * 
 */
@Service("payContractService")
public class PayContractServiceImpl extends BaseServiceImpl<PayContractMapper, PayContractEntity> implements IPayContractService{

    @Autowired
    private IUserApi userApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public List<PayContractVO> pageList(Page pages, QueryWrapper queryWrapper) {
        List<PayContractVO> list = baseMapper.pageList(pages, queryWrapper);
        //部分单据无指定经办人这里查询一下
        if (CollectionUtils.isNotEmpty(list)){
            List<String> employeeCodeS = list.stream().filter(item -> null != item.getType() && Arrays.asList(8, 9, 10).contains(item.getType()))
                    .map(PayContractVO::getEmployeeName).collect(Collectors.toList());
            logger.info("employeeCodeS========{}",JSONObject.toJSONString(employeeCodeS));
            CommonResponse<List<UserVO>> listCommonResponse = userApi.queryUserByUserCodes(employeeCodeS.toArray(new String[list.size()]));
            if (listCommonResponse.isSuccess()){
                Map<String, UserVO> userMap = listCommonResponse.getData()
                        .stream().filter(item -> null != item.getId()).collect(Collectors.toMap(UserVO::getUserCode, Function.identity(), (v1, v2) -> v2));
                logger.info("employeeCodeSMap========{}",JSONObject.toJSONString(userMap));
                list.forEach(item -> {
                    if (null != item.getType() && Arrays.asList(8, 9, 10).contains(item.getType())) {
                        item.setEmployeeId(userMap.get(item.getEmployeeName()).getId());
                        item.setEmployeeName(userMap.get(item.getEmployeeName()).getUserName());
                    }
                });
            }
        }
        return list;
    }

    @Override
    public PayFlowVO getFlow(String date) {
        List<PayFlowVO> payFlowVOList = baseMapper.getFlow(date);
        PayFlowVO payFlowVO = new PayFlowVO();
        if (CollectionUtils.isNotEmpty(payFlowVOList)){
            BigDecimal inMny = payFlowVOList.stream().filter(s->s.getInMny() != null).map(PayFlowVO::getInMny)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outMny = payFlowVOList.stream().filter(s->s.getOutMny() != null).map(PayFlowVO::getOutMny)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            payFlowVO.setInMny(inMny);
            payFlowVO.setOutMny(outMny);
        }
        return payFlowVO;
    }
}
