package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.vo.TenderFundsVO;
import com.ejianc.business.oa.bean.CarEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import com.ejianc.business.bid.service.IProjectPersonAffirmService;
import com.ejianc.business.bid.vo.ProjectPersonAffirmVO;

/**
 * 投标管理-确认项目经理及技术负责人
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("projectPersonAffirm")
public class ProjectPersonAffirmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_PROJECT_PERSON_AFFIRM";

    @Autowired
    private IProjectPersonAffirmService service;

    @Autowired
    private SessionManager sessionManager;

    @GetMapping(value = "getByBusOpportunityId")
    public CommonResponse<JSONObject> getByBusOpportunityId(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        List<ProjectPersonAffirmVO> dataList = new ArrayList<>();
        List<ProjectPersonAffirmEntity> list = service.getByBusOpportunityId(id);
        if(CollectionUtils.isNotEmpty(list)) {
            dataList = BeanMapper.mapList(list, ProjectPersonAffirmVO.class);
        }
        resp.put("detailList", dataList);
        return CommonResponse.success(resp);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ProjectPersonAffirmVO> saveOrUpdate(@RequestBody ProjectPersonAffirmVO saveOrUpdateVO) {
        QueryWrapper queryWrapper = new QueryWrapper<ProjectPersonAffirmEntity>().eq("opportunity_id", saveOrUpdateVO.getOpportunityId());
        if (null != saveOrUpdateVO.getId()){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List oldList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(oldList) && oldList.size() > 0){
            return CommonResponse.error("该工程已做确认项目经理及技术负责人，请切换工程！");
        }

        ProjectPersonAffirmVO vo = service.saveOrUpdate(saveOrUpdateVO);

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ProjectPersonAffirmVO> queryDetail(Long id) {
    	ProjectPersonAffirmEntity entity = service.selectById(id);
    	ProjectPersonAffirmVO vo = BeanMapper.map(entity, ProjectPersonAffirmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ProjectPersonAffirmVO> vos) {
        service.removeByIds(vos.stream().map(ProjectPersonAffirmVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ProjectPersonAffirmVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));


        IPage<ProjectPersonAffirmEntity> page = service.queryPage(param,false);
        IPage<ProjectPersonAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPersonAffirmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = sessionManager.getUserContext().getAuthOrgIds();
        List<Long> orgIds = new ArrayList<>();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgIds.addAll(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(","))
                    .map(Long::parseLong).collect(Collectors.toList())).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }else {//pc端查询
            //本下
            orgIds.addAll(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            //本上
            orgIds.addAll(iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ProjectPersonAffirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectPersonAffirm-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refProjectPersonAffirmData", method = RequestMethod.GET)
    public CommonResponse<IPage<ProjectPersonAffirmVO>> refProjectPersonAffirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectPersonAffirmEntity> page = service.queryPage(param,false);
        IPage<ProjectPersonAffirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPersonAffirmVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
