package com.ejianc.business.invest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.business.invest.vo.ProjectDebtVO;
import com.ejianc.business.invest.vo.ProjectRepaymentVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.invest.mapper.ProjectDebtMapper;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.service.IProjectDebtService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 项目投资-项目借款
 * 
 * @author generator
 * 
 */
@Service("projectDebtService")
public class ProjectDebtServiceImpl extends BaseServiceImpl<ProjectDebtMapper, ProjectDebtEntity> implements IProjectDebtService{
    @Autowired
    private IProjectRepaymentService projectRepaymentService;

    @Override
    public ProjectDebtVO queryProjectDebtData(Long projectId) {
        ProjectDebtVO projectDebtVO = new ProjectDebtVO();
        ProjectRepaymentVO projectRepaymentVO = projectRepaymentService.queryProjectDebt(projectId);

        if (null != projectRepaymentVO){
            projectDebtVO.setTotalDebtMny(projectRepaymentVO.getTotalDebtMny());
            projectDebtVO.setTotalDebtResidueMny(projectRepaymentVO.getTotalDebtResidueMny());
            projectDebtVO.setTotalRepaymentMny(projectRepaymentVO.getTotalRepaymentMny());
        }
        return projectDebtVO;
    }

    @Override
    public List<ProjectDebtVO> pageList(Page<ProjectDebtEntity> page, QueryWrapper<ProjectDebtVO> queryWrapper) {
        return baseMapper.pageList(page, queryWrapper);
    }

    @Override
    public BigDecimal underpaymentMny(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        QueryWrapper<ProjectDebtVO> queryWrapper = changeToQueryWrapper(param);
        Page<ProjectDebtEntity> page = new Page<>(1,-1);
        List<ProjectDebtVO> list = this.pageList(page,queryWrapper);
        BigDecimal totalResidueMny = list.stream().filter(item -> null != item.getTotalResidueMny()).map(ProjectDebtVO::getTotalResidueMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal remainInterestMny = baseMapper.remainInterestMny(projectId);
        BigDecimal underpaymentMny = ComputeUtil.safeAdd(totalResidueMny, remainInterestMny);

        return underpaymentMny;
    }
}
