package com.ejianc.business.bid.api;


import com.ejianc.business.bid.hystrix.BidManageHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * @author jiangyikai
 * @version 1.0
 * @description:
 * @date 2022/2/22
 */
@FeignClient(name = "ejc-bid-web", url = "${common.env.feign-client-url}", path = "ejc-bid-web", fallback = BidManageHystrix.class)
public interface BidManageApi {
    /**
     * 根据id修改项目立项使用状态
     */
    @GetMapping(value = "/api/bid/changeUseFlag")
    public CommonResponse<String> changeUseFlag(@RequestParam(value = "id", required = true) Long id, @RequestParam("useFlag") Integer useFlag);

}
