package com.ejianc.business.bid.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 投标状态
 * @date 2021/11/17
 */
public enum BidStateEnum {

    GEN_ZONG_ZHONG(1, "跟踪中"),
    YI_BAO_MING(2, "已评审"),
    YI_JIE_SHU(0, "已结束"),
    JIN_XING_ZHONG(3, "进行中");

    private Integer code;
    private String name;


    private static Map<Integer, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(GEN_ZONG_ZHONG.getCode(), GEN_ZONG_ZHONG.getName());
        enumMap.put(YI_BAO_MING.getCode(), YI_BAO_MING.getName());
        enumMap.put(YI_JIE_SHU.getCode(), YI_JIE_SHU.getName());
        enumMap.put(JIN_XING_ZHONG.getCode(), JIN_XING_ZHONG.getName());
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }

    BidStateEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }


    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
