package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.vo.EnrollVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 投标报名
 *
 * @author generator
 */
@Controller
@RequestMapping("enroll")
@Api(value = "投标报名", tags = {"投标报名"})
public class EnrollController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_ENGINEERING_CODE";

    @Autowired
    private IEnrollService service;

    @Autowired
    private IInfoTrackService infoTrackService;

    @Autowired
    private IRecordService recordService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EnrollVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody EnrollVO saveorUpdateVO) {
        EnrollEntity entity = BeanMapper.map(saveorUpdateVO, EnrollEntity.class);
        if ((entity.getId() == null || entity.getId() == 0) && StringUtils.isEmpty(entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        EnrollVO vo = BeanMapper.map(entity, EnrollVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("参照信息跟踪新增")
    @RequestMapping(value = "/addByInfotrack", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EnrollVO> addByInfotrack(@RequestParam Long id) {
        InfoTrackEntity infoTrack = infoTrackService.selectById(id);
        EnrollEntity vo = new EnrollEntity();
        if (infoTrack != null) {
            vo.setBillCode(infoTrack.getBillCode());
            vo.setEngineeringName(infoTrack.getEngineeringName());
            vo.setInfoSource(infoTrack.getInfoSource());
            vo.setInfoSourceName(infoTrack.getInfoSourceName());
            vo.setFollowPerson(infoTrack.getUnitDirector());
            vo.setFollowPersonName(infoTrack.getUnitDirectorName());
            vo.setFollowPersonPhone(infoTrack.getUnitDirectorPhone());
            vo.setBidState(BidStateEnum.JIN_XING_ZHONG.getCode());
            vo.setProjectManager(infoTrack.getProjectBidManage());
            vo.setProjectManagerName(infoTrack.getProjectBidManageName());
            vo.setProjectManagerPhone(infoTrack.getProjectBidManagePhone());
            vo.setIsPrecheck(BidCommonConsts.NO);
            vo.setAddress(infoTrack.getAddress());
            vo.setArea(infoTrack.getArea());
            vo.setProvince(infoTrack.getProvince());
            vo.setCity(infoTrack.getCity());
            vo.setRegion(infoTrack.getRegion());
            vo.setIsGive(BidCommonConsts.NO);

            vo.setConstructionUnit(infoTrack.getConstructionUnit());
            vo.setConstructionUnitName(infoTrack.getConstructionUnitName());
            vo.setOwnerClient(infoTrack.getOwnerEntrust());
            vo.setOwnerClientPhone(infoTrack.getOwnerEntrustPhone());

            vo.setFundsSource(infoTrack.getFundsSource());
            vo.setFundsSourceName(infoTrack.getFundsSourceName());
            vo.setBiddingForm(infoTrack.getBiddingForm());
            vo.setBidScope(infoTrack.getBidRange());
            vo.setEngineeringType(infoTrack.getEngineeringType());
            vo.setEngineeringTypeName(infoTrack.getEngineeringTypeName());
            vo.setPlanDay(infoTrack.getPlanDuration());
            vo.setCostTotal(infoTrack.getTheInvestmentAmount());
            vo.setRemark(infoTrack.getRemark());
            vo.setBidStage(BidStageEnum.TOU_BIAO_BAO_MING.getCode());

            vo.setBidAgentOrg(infoTrack.getBiddingAgency());
            vo.setIsGive(BidCommonConsts.NO);
            vo.setIsStop(BidCommonConsts.NO);
            //0来源信息跟踪
            vo.setSourceType(BidCommonConsts.NO);
            vo.setSourceId(id);

        }

        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(vo, EnrollVO.class));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EnrollVO> queryDetail(@RequestParam Long id) {
        EnrollEntity entity = service.selectById(id);
        EnrollVO vo = BeanMapper.map(entity, EnrollVO.class);
        vo.setRecords(recordService.getRecord(vo.getBillCode()));
        if(null != vo){
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setBidStageName(BidStageEnum.getNameByCode(vo.getBidStage()));
            vo.setBidStateName(BidStateEnum.getNameByCode(vo.getBidState()));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EnrollVO> vos) {
        service.removeByIds(vos.stream().map(EnrollVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EnrollEntity> page = service.queryPage(param, false);
        IPage<EnrollVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EnrollVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EnrollEntity> list = service.queryList(param);
        List<EnrollVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, EnrollVO.class);
            voList.forEach(vo -> {
                vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setBidStageName(BidStageEnum.getNameByCode(vo.getBidStage()));
                vo.setBidStateName(BidStateEnum.getNameByCode(vo.getBidState()));
            });
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Enroll-export.xlsx", beans, response);
    }


    /***
     * @description:
     * 1. 资格预审:     是否资格预审:是
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.bid.vo.EnrollVO>>
     * @author songlx
     * @date: 2021/11/17
     */
    @ApiOperation("参照")
    @RequestMapping(value = "/refEnrollData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> refEnrollData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("isStop", new Parameter(QueryParam.EQ, BidCommonConsts.NO));
        param.getParams().put("bidState", new Parameter(QueryParam.NE, BidStateEnum.YI_JIE_SHU));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("bidOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("isPrecheck") != null){
                param.getParams().put("isPrecheck", new Parameter(QueryParam.EQ, _con.get("isPrecheck")));
            }
            if(_con.get("bidState") != null){
                param.getParams().put("bidState", new Parameter(QueryParam.IN, _con.get("bidState")));
            }
            if(_con.get("isPreChecked") != null){
                param.getParams().put("isPreChecked", new Parameter(QueryParam.EQ, _con.get("isPreChecked")));
            }
            if(_con.get("isBidChecked") != null){
                param.getParams().put("isBidChecked", new Parameter(QueryParam.EQ, _con.get("isBidChecked")));
            }
            if(_con.get("isBidddingChecked") != null){
                param.getParams().put("isBidddingChecked", new Parameter(QueryParam.EQ, _con.get("isBidddingChecked")));
            }
            if(_con.get("isSummary") != null){
                Page<EnrollEntity> page = new Page<>();
                page.setSize(pageSize);
                page.setCurrent(pageNumber);
                QueryWrapper wrapper = changeToQueryWrapper(param);
                wrapper.apply("(is_bid_checked = 1 or (is_biddding_checked = 1 or is_precheck = 1 and is_give = 1))");
                IPage summarypage = service.page(page, wrapper);
                IPage<EnrollVO> pageData = new Page<>(summarypage.getCurrent(), summarypage.getSize(), summarypage.getTotal());
                List<EnrollVO> enrollVOS = BeanMapper.mapList(page.getRecords(), EnrollVO.class);
                for (EnrollVO enrollVO : enrollVOS) {
                    enrollVO.setBidStateName(BidStateEnum.getNameByCode(enrollVO.getBidState()));
                    enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode(enrollVO.getBiddingForm()));
                }
                pageData.setRecords(enrollVOS);
                return CommonResponse.success("查询参照数据成功！", pageData);
            }

        }

        IPage<EnrollEntity> page = service.queryPage(param, false);
        IPage<EnrollVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EnrollVO> enrollVOS = BeanMapper.mapList(page.getRecords(), EnrollVO.class);
        for (EnrollVO enrollVO : enrollVOS) {
            enrollVO.setBidStateName(BidStateEnum.getNameByCode(enrollVO.getBidState()));
            enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode(enrollVO.getBiddingForm()));
        }
        pageData.setRecords(enrollVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
