package com.ejianc.business.bid.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.consts.NoticeEnum;
import com.ejianc.business.bid.service.EnrollMessageService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping(value = "/enrollWarn")
public class EnrollWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EnrollMessageService messageService;
    @Autowired
    private IEnrollService enrollservice;
    //提前7/5/3天进行三次预警
    private static  int[] arr= {3,5,7};

    private static final String PC_A_URL = "/ejc-bid-frontend/#/enroll/card?id=";

    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;


    @RequestMapping(value = "/expireWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> overdue(HttpServletRequest request) {
        logger.info("接收到投标报名Task参数：{}", request);
        List<EnrollVO> enrollVOS = enrollservice.queryBidOpeningSoon();
        if (CollectionUtils.isNotEmpty(enrollVOS)){
         enrollVOS.forEach(item->{
             //开标日期
             String biddingDate = DateUtil.format(item.getBiddingDate(), "yyyy-MM-dd");
             String today= DateUtil.today();
             //提前7/5/3天进行三次预警
             long l = (DateUtil.parse(today).getTime() +arr[0]*(24 * 3600 * 1000));
             long l1 = (DateUtil.parse(today).getTime() +arr[1]*(24 * 3600 * 1000));
             long l2 = (DateUtil.parse(today).getTime() +arr[2]*(24 * 3600 * 1000));
             if (l==DateUtil.parse(biddingDate).getTime() || l1==DateUtil.parse(biddingDate).getTime() || l2==DateUtil.parse(biddingDate).getTime()) {
                 messageService.sendMsg(item,new String[]{String.valueOf(item.getFollowPerson())},NoticeEnum.BID_ENROLL);
             }
         });
        }
        return CommonResponse.success("发送消息成功！");
    }


    /**
     * 项目评审跟进七天未修改预警
     * @param
     * @return
     */
    @PostMapping(value = "enrollFollowWarn")
    public CommonResponse<String> enrollFollowWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        String warnLevel = "";
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行项目评审预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行项目评审预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行项目评审预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行项目评审预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                //p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                //p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = enrollservice.queryWarn(sqlParamList);

        logger.info("消息条数---{}",result.size());

        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行【项目评审】预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));

    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("bill_code").toString());
            vo.setPcTitle("项目评审");
            vo.setPcUrl(PC_A_URL + m.get("id"));
            vo.setOrgId(Long.valueOf(m.get("org_id").toString()));
            vo.setOrgName(m.get("org_name").toString());
            vo.setSourceId(m.get("source_id").toString());
            vo.setTenantId(Long.valueOf((String) m.get("tenant_id")));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent);
            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }
}
