package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * 投标停止申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_stop_apply")
public class StopApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="enroll_id")
    private Long enrollId; // 投标报名ID
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="engineering_code")
    private String engineeringCode; // 工程编码
    @TableField(value="apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    @TableField(value="stop_reason")
    private String stopReason; // 终止原因
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="employee_id")
    private Long employeeId;//编制人
    @TableField(value="employee_name")
    private String employeeName;//编制人名称
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;//编制时间
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称

    @TableField(value="org_code")
    private String orgCode; // 所属组织编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    

    /**
     * 投标报名ID
     */
    public Long getEnrollId() {
        return enrollId;
    }
    /**
     * 投标报名ID
     */
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }

    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 终止原因
     */
    public String getStopReason() {
        return stopReason;
    }

    /**
     * 终止原因
     */
    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }
    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
}
