package com.ejianc.business.bid.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.InfoTrackRecordContentEntity;
import com.ejianc.business.bid.consts.ProjectTrackSurveyEnum;
import com.ejianc.business.bid.service.IInfoTrackRecordContentService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.utils.AddressResolutionUtil;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.bid.vo.TrackDataVO;
import com.ejianc.business.bid.vo.TrackSimpleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-04-29 14:34
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/projectSurvey")
public class ProjectSurveyController {

    @Autowired
    private IInfoTrackService infoTrackService;

    @Autowired
    private IDefdocApi defdocApi;

    private final String ENGINE_TYPE = "pro-market-project-engineeType";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInfoTrackRecordContentService infoTrackRecordContentService;

    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value = "/projectCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectCount(@RequestParam(value = "range", required = false) String range,
                                                          @RequestParam(value = "name", required = false) String name,
                                                          @RequestParam(value = "dateIn", required = false) String dateIn,
                                                          @RequestParam(value = "orgId", required = false) Long orgId) {

        List<InfoTrackVO> vos = infoTrackService.trackCount(range, name, dateIn, orgId);
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (InfoTrackVO vo : vos) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getArea())) {
                if (vo.getArea().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                    if (areaMmap != null) {
                        String province = areaMmap.get("province") == null ? "其他" : areaMmap.get("province");
                        String city = areaMmap.get("city") == null ? "其他" : areaMmap.get("city");
                        String county = areaMmap.get("county") == null ? "其他" : areaMmap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }
        }

        String rangeType = null;
        List<TrackDataVO> dataVOS = new ArrayList<>();

        if (StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = projectCountByName(name, vos, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, vos, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = AddressResolutionUtil.getProvincePinYin(provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, TrackDataVO> countyMap = new HashMap<>();
                    for (InfoTrackVO vo : vos) {
                        String county = vo.getCounty();
                        if (!countyMap.containsKey(county)) {
                            TrackDataVO pvo = new TrackDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            countyMap.put(county, pvo);
                        } else {
                            TrackDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<TrackDataVO>(countyMap.values());
                    Map<String, List<InfoTrackVO>> map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getCounty));
                    for (TrackDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoTrackVO> projectCountVOS = map.get(dataVO.getName());
                            List<TrackSimpleVO> projectVos = new ArrayList<>();
                            for (InfoTrackVO projectCountVO : projectCountVOS) {
                                TrackSimpleVO projectVo = new TrackSimpleVO();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getEngineeringName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                } else {
                    rangeType = AddressResolutionUtil.getProvincePinYin(provinceSet.iterator().next());
                    Map<String, TrackDataVO> cityMap = new HashMap<>();
                    for (InfoTrackVO vo : vos) {
                        String city = vo.getCity();
                        if (!cityMap.containsKey(city)) {
                            TrackDataVO pvo = new TrackDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            cityMap.put(city, pvo);
                        } else {
                            TrackDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<TrackDataVO>(cityMap.values());
                    Map<String, List<InfoTrackVO>> map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getCity));
                    for (TrackDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoTrackVO> projectCountVOS = map.get(dataVO.getName());
                            List<TrackSimpleVO> projectVos = new ArrayList<>();
                            for (InfoTrackVO projectCountVO : projectCountVOS) {
                                TrackSimpleVO projectVo = new TrackSimpleVO();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getEngineeringName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, TrackDataVO> provinceMap = new HashMap<>();
                for (InfoTrackVO vo : vos) {
                    String province = vo.getProvince();
                    if (!provinceMap.containsKey(province)) {
                        TrackDataVO pvo = new TrackDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        provinceMap.put(province, pvo);
                    } else {
                        TrackDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<InfoTrackVO>> map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getProvince));
                dataVOS = new ArrayList<TrackDataVO>(provinceMap.values());
                for (TrackDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<InfoTrackVO> projectCountVOS = map.get(dataVO.getName());
                        List<TrackSimpleVO> projectVos = new ArrayList<>();
                        for (InfoTrackVO projectCountVO : projectCountVOS) {
                            TrackSimpleVO projectVo = new TrackSimpleVO();
                            projectVo.setId(projectCountVO.getId());
                            projectVo.setName(projectCountVO.getEngineeringName());
                            projectVo.setOrgId(projectCountVO.getOrgId());
                            projectVos.add(projectVo);
                        }
                        dataVO.setProjectList(projectVos);
                    }
                }
            }
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", vos.size());
        jsonObject.put("data", dataVOS);
        //在这个地方处理四个直辖市
        if (rangeType!=null){
            if (rangeType.contains("beijing")){
                rangeType="beijing";
            }
            else if (rangeType.contains("shanghai")){
                rangeType="beijing";
            }
            else if(rangeType.contains("chongqing")){
                rangeType="chongqing";
            }
            else if (rangeType.contains("tianjin")){
                rangeType="tianjin";
            }
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);

        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    private List<TrackDataVO> projectCountByName(String name, List<InfoTrackVO> list, Integer type) {
        List<TrackDataVO> dataVOS = new ArrayList<>();
        Map<String, TrackDataVO> map = new HashMap<>();
        for (InfoTrackVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                if (!map.containsKey(childrenName)) {
                    TrackDataVO pvo = new TrackDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    map.put(childrenName, pvo);
                } else {
                    TrackDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<InfoTrackVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoTrackVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoTrackVO::getCounty));
        }
        ArrayList<TrackDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (TrackDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<InfoTrackVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                List<TrackSimpleVO> projectVos = new ArrayList<>();
                for (InfoTrackVO projectCountVO : projectCountVOS) {
                    TrackSimpleVO projectVo = new TrackSimpleVO();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getEngineeringName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVos.add(projectVo);
                }
                dataVO.setProjectList(projectVos);
            }
        }
        return projectDataVOS;

    }


    @GetMapping(value = "countByEngineeType")
    public CommonResponse<List<JSONObject>> countByEngineeType(@RequestParam(value = "orgId", required = false) Long orgId,
                                                          @RequestParam(value = "yearType", required = false) String yearType) {
        List<JSONObject> resp = new ArrayList<>();
        String year= EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)){//上一年
            year = (EJCDateUtil.getYear()-1)+ "";
        }
        String thisYear = year;
        List<InfoTrackVO> trackVOS = infoTrackService.trackCount(null, null, "0".equals(yearType) ? ProjectTrackSurveyEnum.LASTYEAR.getCode() : null, orgId);
        //查询自定义档案
        CommonResponse<List<DefdocDetailVO>> docResp =  defdocApi.getDefDocByDefCode(ENGINE_TYPE);
        if(!docResp.isSuccess()) {
            logger.error("查询档案分类-{}下档案失败, {}", ENGINE_TYPE, JSONObject.toJSONString(docResp));
            return CommonResponse.error("获取项目工程类型信息失败！");
        }
        JSONObject tmpMap = null;
        for(DefdocDetailVO doc : docResp.getData()) {
            tmpMap = new JSONObject();
            tmpMap.put("name", doc.getName());
            tmpMap.put("typeId", doc.getId());
            tmpMap.put("totalNums", 0);
            tmpMap.put("totalMny", BigDecimal.ZERO);
            resp.add(tmpMap);
        }

        tmpMap = new JSONObject();
        tmpMap.put("name", "其他");
        tmpMap.put("typeId", 123L);
        tmpMap.put("totalNums", 0);
        tmpMap.put("totalMny", BigDecimal.ZERO);
        resp.add(tmpMap);


        if(CollectionUtils.isNotEmpty(trackVOS)) {
            Map<Long, List<InfoTrackVO>> trackMap = trackVOS.stream().map(track -> {
                if(null == track.getEngineeType()) {
                    track.setEngineeType(123L);
                }
                return track;
            }).collect(Collectors.groupingBy(InfoTrackVO::getEngineeType));
            List<InfoTrackVO> tractList = null;
            for(JSONObject json : resp) {
                tractList = trackMap.get(json.getLong("typeId"));
                if(CollectionUtils.isNotEmpty(tractList)) {
                    json.put("totalNums", tractList.size());
                    json.put("totalMny", tractList.stream().map(InfoTrackVO::getInvestorAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                }
            }
        }

        return CommonResponse.success("查询成功！", resp);
    }

    @GetMapping(value = "businessStatusCount")
    public CommonResponse<JSONObject> businessStatusCount(@RequestParam(value = "orgId", required = false) Long orgId,
                                                                    @RequestParam(value = "yearType", required = false) String yearType) {
        JSONObject resp = new JSONObject();
        String year= EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)){//上一年
            year = (EJCDateUtil.getYear()-1)+ "";
        }
        String thisYear = year;
        Integer buildNum = 0;
        Integer thisYearProjectNum = 0;
        List<InfoTrackVO> trackVOS = infoTrackService.trackCount(null, null, "0".equals(yearType) ? ProjectTrackSurveyEnum.LASTYEAR.getCode() : null, orgId);
        resp.put("totalNumAll", trackVOS.size());
        resp.put("totalNum", trackVOS.size());

        Map<String, JSONObject> statusMap = new HashMap<>();
        List<String> allTrackStatus = new ArrayList<>();
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_TRACKING.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_STOP.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_ENROLL.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_HASWIN.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_NOTWIN.getCode());


        JSONObject tmpStatus = null;
        for(InfoTrackVO e : trackVOS) {
            if(ProjectTrackSurveyEnum.RANGE_TRACKING.getCode().equals(e.getTrackStatus())) {
                buildNum++;
            }
            if(thisYear.equals(DateUtil.format(e.getCreateTime(), "yyyy"))) {
                thisYearProjectNum++;
            }
            if(!statusMap.containsKey(e.getTrackStatus())) {
                tmpStatus = new JSONObject();
                tmpStatus.put("businessStatus", e.getTrackStatus());
                tmpStatus.put("businessStatusName", ProjectTrackSurveyEnum.getNameByCode(e.getTrackStatus()));
                tmpStatus.put("num", 0);
                statusMap.put(e.getTrackStatus(), tmpStatus);
                allTrackStatus.remove(e.getTrackStatus());
            }

            tmpStatus = statusMap.get(e.getTrackStatus());
            tmpStatus.put("num",tmpStatus.getInteger("num")+1);
            statusMap.put(e.getTrackStatus(), tmpStatus);
        }

        if(CollectionUtils.isNotEmpty(allTrackStatus)) {
            for(String trackStatus : allTrackStatus) {
                tmpStatus = new JSONObject();
                tmpStatus.put("businessStatus", trackStatus);
                tmpStatus.put("businessStatusName", ProjectTrackSurveyEnum.getNameByCode(trackStatus));
                tmpStatus.put("num", 0);
                statusMap.put(trackStatus, tmpStatus);
            }
        }

        resp.put("buildNum", buildNum);
        resp.put("thisYearProjectNum", thisYearProjectNum);
        resp.put("detail", statusMap.values());

        return CommonResponse.success(resp);
    }

    private String dofiter(String name) {
        if (name.length()<=2){
            return name;
        }else{
            String newName=name.substring(0,2);
            int i = name.length() - 2;
            for (int j = 0; j < i; j++){
                newName+="*";
            }
            return newName;
        }

    }
    @ApiOperation("查询跟踪项目信息展示表")
    @RequestMapping(value = "/queryListForTrack", method = RequestMethod.POST)
    public CommonResponse<IPage<InfoTrackVO>> queryListForTrack(@RequestBody QueryParam param) {

        Map<String, Object> queryParam = new HashMap<>();
        if (ObjectUtil.isNotEmpty(param.getOrderMap())){
            queryParam.put("orderType", param.getOrderMap().get("billDate"));
        }
        queryParam.put("pageSize", param.getPageSize());
        Integer startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex()-1) * param.getPageSize();
        queryParam.put("startLine", startLine);
        if(StringUtils.isNotBlank(param.getSearchText())) {
            queryParam.put("searchText", param.getSearchText());
        }
        Map<String, Parameter> parameterMap = param.getParams();

        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        queryParam.put("orgIds", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().remove("orgId");
        for(String key :param.getParams().keySet()) {
            if("billDate".equals(key)) {
                queryParam.put("billDateStart", parameterMap.get(key).getValue().toString().split(",")[0]);
                queryParam.put("billDateEnd", parameterMap.get(key).getValue().toString().split(",")[1]);
            } else {
                queryParam.put(key, parameterMap.get(key).getValue());
            }
        }

        Long total = infoTrackService.countNum(queryParam);
        IPage<InfoTrackVO> resultPage = null;
        if(total == 0) {
            resultPage = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            resultPage.setRecords(new ArrayList<>());
            return CommonResponse.success("查询成功！",resultPage);
        }

        resultPage = new Page<>(param.getPageIndex(), param.getPageSize(), total);
        List<InfoTrackVO> list = infoTrackService.queryTrackList(queryParam);

        List<InfoTrackVO>result=new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            Map<Long, InfoTrackRecordContentEntity> map = getLongInfoTrackRecordContentEntityMap(list);
            list.forEach(record -> {
                InfoTrackVO infoTrackVO = BeanMapper.map(record, InfoTrackVO.class);
                String engineeringName = dofiter(infoTrackVO.getEngineeringName());
                infoTrackVO.setEngineeringName(engineeringName);
                String constructionUnitName = dofiter(infoTrackVO.getConstructionUnitName());
                infoTrackVO.setConstructionUnitName(constructionUnitName);
                InfoTrackRecordContentEntity infoTrackRecordContentEntity = map.get(infoTrackVO.getId());
                if (infoTrackRecordContentEntity!=null){
                    infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                    infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
                }
                result.add(infoTrackVO);
            });
        }
        resultPage.setRecords(result);

        return CommonResponse.success("查询成功！",resultPage);
    }


    @ApiOperation("导出跟踪项目信息展示表")
    @RequestMapping(value = "/excelTrackExport", method = RequestMethod.POST)
    public void excelTrackExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> queryParam = new HashMap<>();
        if (ObjectUtil.isNotEmpty(param.getOrderMap())){
            queryParam.put("orderType", param.getOrderMap().get("billDate"));
        }
//        queryParam.put("pageSize", param.getPageSize());
//        Integer startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex()-1) * param.getPageSize();
//        queryParam.put("startLine", startLine);
        if(StringUtils.isNotBlank(param.getSearchText())) {
            queryParam.put("searchText", param.getSearchText());
        }
        Map<String, Parameter> parameterMap = param.getParams();

        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        queryParam.put("orgIds", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().remove("orgId");
        for(String key :param.getParams().keySet()) {
            if("billDate".equals(key)) {
                queryParam.put("billDateStart", parameterMap.get(key).getValue().toString().split(",")[0]);
                queryParam.put("billDateEnd", parameterMap.get(key).getValue().toString().split(",")[1]);
            } else {
                queryParam.put(key, parameterMap.get(key).getValue());
            }
        }

        List<InfoTrackVO> list = infoTrackService.queryTrackList(queryParam);

        List<InfoTrackVO>result=new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            Map<Long, InfoTrackRecordContentEntity> map = getLongInfoTrackRecordContentEntityMap(list);
            list.forEach(record -> {
                InfoTrackVO infoTrackVO = BeanMapper.map(record, InfoTrackVO.class);
                String engineeringName = dofiter(infoTrackVO.getEngineeringName());
                infoTrackVO.setEngineeringName(engineeringName);
                String constructionUnitName = dofiter(infoTrackVO.getConstructionUnitName());
                infoTrackVO.setConstructionUnitName(constructionUnitName);
                InfoTrackRecordContentEntity infoTrackRecordContentEntity = map.get(infoTrackVO.getId());
                if (infoTrackRecordContentEntity!=null){
                    infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                    infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
                }

                Integer followState = record.getFollowState();
                if (followState==1){
                    infoTrackVO.setFollowStateName("跟踪中");
                } else if (followState==2) {
                    infoTrackVO.setFollowStateName("已评审");
                }else{
                    infoTrackVO.setFollowStateName("已结束");
                }
                if(StringUtils.isNotBlank(infoTrackVO.getTrackStatus())) {
                    infoTrackVO.setTrackStatusName(ProjectTrackSurveyEnum.getNameByCode(infoTrackVO.getTrackStatus()));
                }

                result.add(infoTrackVO);
            });
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result);
        ExcelExport.getInstance().export("InfoTrackNewReport-export.xlsx", beans, response);
    }

    private Map<Long, InfoTrackRecordContentEntity> getLongInfoTrackRecordContentEntityMap(List<InfoTrackVO> records) {
        List<Long>ids = records.stream().map(InfoTrackVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<InfoTrackRecordContentEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(InfoTrackRecordContentEntity::getTrackId,ids);
        List<InfoTrackRecordContentEntity> list = infoTrackRecordContentService.list(queryWrapper);
        Map<Long, InfoTrackRecordContentEntity> map=new HashMap<>();
        list.forEach(infoTrackRecordContentEntity -> {
            if (map.containsKey(infoTrackRecordContentEntity.getTrackId())){
                if (map.get(infoTrackRecordContentEntity.getTrackId())==null){
                    map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
                }
                else if (map.get(infoTrackRecordContentEntity.getTrackId()).getTrackTime()==null ||
                        (infoTrackRecordContentEntity.getTrackTime()!=null &&
                                infoTrackRecordContentEntity.getTrackTime().after(map.get(infoTrackRecordContentEntity.getTrackId()).getTrackTime()))){
                    map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
                }
            }else{
                map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
            }
        });
        return map;
    }

}
