package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.vo.DeployVO;

/**
 * 投标部署
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("deploy")
public class DeployController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IRecordService recordService;
    private static final String BILL_CODE = "BID_DEPLOY";//此处需要根据实际修改

    @Autowired
    private IDeployService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeployVO> saveOrUpdate(@RequestBody DeployVO saveOrUpdateVO) {
        //编号重复校验
        if (null != saveOrUpdateVO.getCode()){
            QueryWrapper<DeployEntity> query = new QueryWrapper();
            query.eq("code", saveOrUpdateVO.getCode());
            if(null != saveOrUpdateVO.getId()) {
                query.ne("id", saveOrUpdateVO.getId());
            }
            List<DeployEntity> billCodeEntityList = service.list(query);
            if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
                return CommonResponse.error("保存失败，组卷号重复！");
            }
        }
    	DeployEntity entity = BeanMapper.map(saveOrUpdateVO, DeployEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                //entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            saveEntity.setCreateUserName(userContext.getUserName());
        }


    	service.saveOrUpdate(entity, false);
    	DeployVO vo = BeanMapper.map(entity, DeployVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeployVO> queryDetail(Long id) {

        DeployVO vo = service.queryDetail(id);
        vo.setRecords(recordService.getRecord(vo.getProjectCode()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeployVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DeployVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeployVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeployVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("endTime");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DeployEntity> page = service.queryPage(param,false);
        IPage<DeployVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeployVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("endTime");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<DeployEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<DeployVO> list = BeanMapper.mapList(pageData.getRecords(), DeployVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    //log.println("判断billState是否为空:" + billState);
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                        //log.print("判断billStateEnum是否为空:" + billStateEnum);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                    }
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("Deploy-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDeployData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeployVO>> refDeployData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeployEntity> page = service.queryPage(param,false);
        IPage<DeployVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeployVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
