package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.consts.ProjectTrackSurveyEnum;
import com.ejianc.business.bid.mapper.InfoTrackMapper;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;



/**
 * 投标信息跟踪
 * 
 * @author generator
 * 
 */
@Service("infoTrackService")
public class InfoTrackServiceImpl extends BaseServiceImpl<InfoTrackMapper, InfoTrackEntity> implements IInfoTrackService{

    @Autowired
    private InfoTrackMapper mapper;

    @Value("${pro.param.currentProvince:#{NULL}}")
    private String currentProvince;
    @Value("${pro.param.province:#{NULL}}")
    private String BASE_PROVINCE;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<String> countNameRepeatNum(List<String> nameItems) {
        return mapper.countNameRepeatNum(nameItems);
    }

    @Override
    public List<InfoTrackVO> queryRecordList() {
        return mapper.queryRecordList();
    }


    @Override
    public List<InfoTrackVO> trackCount(String range, String name, String dateIn, Long orgId) {
        String trackStatus=null;
        //今年
        if (ProjectTrackSurveyEnum.THISYEAR.getCode().equals(dateIn)){
            dateIn = EJCDateUtil.getYear()+"";
        }
        //上一年
        if (ProjectTrackSurveyEnum.LASTYEAR.getCode().equals(dateIn)){
            dateIn = (EJCDateUtil.getYear()-1)+ "";
        }

        Long curOrgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(curOrgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> orgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                orgIds.add(org.getId());
            } else {
                //普通组织
                orgIds.add(org.getId());
            }
        });

        List<InfoTrackVO> tractList = mapper.trackCount(trackStatus, dateIn, orgIds);
        if(CollectionUtils.isNotEmpty(tractList)) {
            tractList.stream().forEach(track -> {
                if (StringUtils.isNotEmpty(track.getArea())){
                    String areaName=null;
                    if (currentProvince.contains("shenzhen")){
                        areaName = track.getArea().replace("/", "");
                    }else {
                        areaName = track.getArea().replace(",", "").replaceAll("\\/","");
                    }
                    track.setArea(areaName);
                }else {
                    track.setArea(track.getArea());
                }
            });
        }
        return tractList;
    }

    @Override
    public Long countNum(Map<String, Object> queryParam) {
        return mapper.countNum(queryParam);
    }

    @Override
    public List<InfoTrackVO> queryTrackList(Map<String, Object> queryParam) {
        return mapper.queryTrackList(queryParam);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
