package com.ejianc.business.bid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bid.bean.DeployContentEntity;
/**
 * 投标部署
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_deploy")
public class DeployEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="end_time")
    private Date endTime; // 截标时间
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // parentOrgId
    @TableField(value="parent_org_code")
    private String parentOrgCode; // parentOrgCode
    @TableField(value="parent_org_name")
    private String parentOrgName; // parentOrgName
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="code")
    private String code; // 编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态

    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="cur_changing_deploy_id")
    private Long curChangingDeployId; // 当前对应的变更投标部署Id
    @TableField(value="change_state")
    private Integer changeState; // 变更状态

    
    
    @TableField(exist=false)
    @SubEntity(serviceName="deployContentService",pidName = "deployId")
    private List<DeployContentEntity> detailList = new ArrayList<>(); // 投标部署子表

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getCurChangingDeployId() {
        return curChangingDeployId;
    }

    public void setCurChangingDeployId(Long curChangingDeployId) {
        this.curChangingDeployId = curChangingDeployId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<DeployContentEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DeployContentEntity> detailList) {
        this.detailList = detailList;
    }
}
