package com.ejianc.business.bidprice.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 报价记录
 *
 * @author baipengyan
 */
public interface IMaterialQuoteService extends IBaseService<MaterialQuoteEntity> {

	/**
	 * 生成供应商报价二维码
	 *
	 * @param inquiryId 询价单id
	 *
	 * @return {@link JSONObject}
	 */
	JSONObject generateQrCode(Long inquiryId);

	/**
	 * 获取验证码
	 *
	 * @param inquiryId   询价单id
	 * @param phoneNumber 电话号码
	 * @param dialog      是否是登录弹窗
	 */
	void fetchVerifyCode(Long inquiryId, String phoneNumber, Boolean dialog) throws Exception;

	/**
	 * 登录
	 *
	 * @param phoneNumber 电话号码
	 * @param validate    验证码
	 */
	void login(String phoneNumber, String validate);

}
