package com.ejianc.business.bidprice.material.controller;

import java.io.Serializable;

import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;

/**
 * 材料询价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialInquiry")
@Api(value = "材料询价", tags = {"材料询价"})
public class MaterialInquiryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MATERIAL_INQUIRY";//此处需要根据实际修改

    @Autowired
    private IMaterialInquiryService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialInquiryVO saveOrUpdateVO) {
    	MaterialInquiryEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialInquiryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MaterialInquiryVO vo = BeanMapper.map(entity, MaterialInquiryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> queryDetail(@RequestParam Long id) {
    	MaterialInquiryEntity entity = service.selectById(id);
    	if(entity == null){
    	    return CommonResponse.error("查询详情失败，数据不存在！",null);
        }
    	MaterialInquiryVO vo = BeanMapper.map(entity, MaterialInquiryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialInquiryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialInquiryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialInquiryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
        }

        IPage<MaterialInquiryEntity> page = service.queryPage(param,false);
        IPage<MaterialInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialInquiryVO> vos = BeanMapper.mapList(page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
        }
        pageData.setRecords(vos);
        //返回回显筛选条件时重置为已截止
        if(param.getParams().containsKey("quoteEndDate")){
            param.getParams().remove("quoteEndDate");
            param.getParams().put("inquiryState",new Parameter(QueryParam.EQ,InquiryStateEnum.EXPIRATION_STATE.getCode()));
        }

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
        }
        List<MaterialInquiryEntity> list = service.queryList(param);
        List<MaterialInquiryVO> vos = BeanMapper.mapList(list, MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("MaterialInquiry-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialInquiryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> refMaterialInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("purchaseSubject");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("inquiryState", new Parameter(QueryParam.EQ,InquiryStateEnum.EXPIRATION_STATE.getCode()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<MaterialInquiryEntity> page = service.queryPage(param,false);
        IPage<MaterialInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialInquiryVO> vos = BeanMapper.mapList(page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
